/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.bes.util.ActivityUtils;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.bes.BESActionBase;
import de.fzj.unicore.ucc.bes.BESUCCConstants;
import de.fzj.unicore.ucc.util.Builder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RunJob
extends BESActionBase
implements BESUCCConstants {
    protected String besUrl = null;
    protected String jsdlPath = null;
    protected EndpointReferenceType activityEpr;
    private ActivityDocumentType activityDocument;
    protected Builder builder;
    protected boolean synchronous;
    protected boolean brief;
    private static String lastJobDescriptor;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"brief");
        OptionBuilder.withDescription((String)"Short output file names");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"b"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"stdout");
        OptionBuilder.withDescription((String)"Name for storing the standard output");
        OptionBuilder.withArgName((String)"stdout");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"O"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"stderr");
        OptionBuilder.withDescription((String)"Name for storing the standard error");
        OptionBuilder.withArgName((String)"stderr");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"E"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"jsdl");
        OptionBuilder.withDescription((String)"Treat job file as JSDL document");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)"j"));
    }

    public String getName() {
        return "bes-submit-job";
    }

    public String getArgumentList() {
        return "[<jobfile>]";
    }

    public String getSynopsis() {
        return "Runs a job through OGSA-BES. The job definition is read from <jobfile> or stdin. A descriptor file will be written that can be used later with other ucc commands.";
    }

    public String getDescription() {
        return "run a job through UNICORE 6 BES Interface";
    }

    @Override
    public void process() {
        super.process();
        this.setOutputLocation();
        if (this.timing) {
            this.startTime = System.currentTimeMillis();
        }
        this.initBuilder();
        if (this.timing) {
            this.endTime = System.currentTimeMillis();
            long duration = this.endTime - this.startTime;
            this.message("Time: " + duration + " ms.");
        }
        this.runBes();
    }

    protected void initBuilder() {
        String jobFile = null;
        if (this.getCommandLine().getArgs().length > 1) {
            jobFile = this.getCommandLine().getArgs()[1];
            if (this.getCommandLine().hasOption("j")) {
                try {
                    this.verbose("Loading JSDL file.");
                    this.builder = new Builder();
                    this.builder.setMessageWriter((MessageWriter)this);
                    this.builder.setRegistry(this.registry);
                    JobDefinitionDocument jdd = JobDefinitionDocument.Factory.parse((File)new File(jobFile));
                    this.builder.setJob(jdd);
                }
                catch (Exception e) {
                    this.error("Can't parse jsdl file <" + jobFile + ">", e);
                    this.endProcessing();
                }
            } else {
                try {
                    this.builder = new Builder(new File(jobFile));
                    this.builder.setMessageWriter((MessageWriter)this);
                    this.builder.setRegistry(this.registry);
                    this.verbose("Read job from <" + jobFile + ">");
                }
                catch (Exception e) {
                    this.error("Can't parse job file <" + jobFile + ">", e);
                    this.endProcessing();
                }
            }
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int b = 0;
                while ((b = System.in.read()) != -1) {
                    bos.write(b);
                }
                this.builder = new Builder(bos.toString());
                this.verbose("Read job from stdin.");
            }
            catch (Exception e) {
                this.error("Can't read job from stdin.", e);
                this.endProcessing();
            }
        }
    }

    protected void runBes() {
        try {
            this.createActivity();
            if (this.verbose) {
                String url = this.activityEpr.getAddress().getStringValue();
                this.verbose("Job submitted, job url=" + url);
            }
            this.updateBuilder();
        }
        catch (Exception e) {
            this.error("Could not run job.", e);
            this.endProcessing(1);
        }
        this.writeJobIDFile();
        this.endProcessing(0);
    }

    protected void updateBuilder() {
        this.builder.setProperty("activity-epr", this.activityEpr.toString());
        this.builder.setProperty("type", "job");
    }

    protected void createActivity() {
        CreateActivityDocument activityReqDoc = CreateActivityDocument.Factory.newInstance();
        CreateActivityType activityReq = activityReqDoc.addNewCreateActivity();
        ActivityDocumentType activityDoc = activityReq.addNewActivityDocument();
        try {
            activityDoc.setJobDefinition(this.builder.getJob().getJobDefinition());
        }
        catch (Exception e1) {
            this.error("Could not setup job definition.", e1);
            this.endProcessing(1);
        }
        TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).add(2, 2);
        tt.setCalendarValue((Calendar)c);
        activityDoc.setTerminationTime(tt);
        CreateActivityResponseDocument response = null;
        try {
            response = this.factory.createActivity(activityReqDoc);
        }
        catch (NotAcceptingNewActivitiesFault e) {
            this.error("BES is not accepting new activities: ", e);
        }
        catch (InvalidRequestMessageFault e) {
            this.error("invalid request message: ", e);
        }
        catch (UnsupportedFeatureFault e) {
            this.error("Unsupported feature fault: ", e);
        }
        this.activityDocument = response.getCreateActivityResponse().getActivityDocument();
        if (response.getCreateActivityResponse() != null) {
            this.activityEpr = response.getCreateActivityResponse().getActivityIdentifier();
        }
        if (this.activityDocument != null) {
            this.dumpJobProperties();
        }
    }

    protected String getStdOutName() {
        return this.getOption("stdout", "O", "stdout");
    }

    protected String getStdErrName() {
        return this.getOption("stderr", "E", "stderr");
    }

    protected void writeJobIDFile() {
        try {
            File dump = new File(this.output, ActivityUtils.extractRefParamResourceId((EndpointReferenceType)this.activityEpr) + ".job");
            FileWriter fw = new FileWriter(dump);
            this.builder.setProperty("factory-epr", this.factory.getEPR().toString());
            this.builder.writeTo((Writer)fw);
            fw.close();
            this.verbose("Wrote job descriptor to " + dump.getAbsolutePath());
            lastJobDescriptor = dump.getAbsolutePath();
            this.message(dump.getAbsolutePath());
        }
        catch (Exception e) {
            this.error("Could not write job ID file.", e);
        }
    }

    protected void dumpJobProperties() {
        try {
            ActivityDocumentDocument1 ad = ActivityDocumentDocument1.Factory.newInstance();
            ad.setActivityDocument(this.activityDocument);
            String p = ad.toString();
            File dump = new File(this.output, ActivityUtils.extractRefParamResourceId((EndpointReferenceType)this.activityEpr) + ".properties");
            FileWriter fw = new FileWriter(dump);
            fw.append(p);
            fw.close();
            this.message(dump.getAbsolutePath());
        }
        catch (Exception e) {
            this.error("Could not get job properties.", e);
        }
    }

    public static String getLastJobDescriptor() {
        return lastJobDescriptor;
    }

    public String getCommandGroup() {
        return "OGSA-BES";
    }
}

