/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.bes.BESActionBase;
import de.fzj.unicore.ucc.bes.BESUCCConstants;
import eu.unicore.util.httpclient.IClientConfiguration;
import javax.xml.namespace.QName;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.bes.x2006.x08.besFactory.BasicResourceAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemTypeEnumeration;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ListFactoryAttributes
extends BESActionBase
implements BESUCCConstants,
IServiceInfoProvider {
    protected ActivityClient activity;
    protected boolean activityFilter;
    private boolean printDetailed;
    String job;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"long");
        OptionBuilder.withArgName((String)"Print Properties in XML");
        OptionBuilder.withDescription((String)"Print Properties in XML");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
    }

    @Override
    public void process() {
        super.process();
        this.getFactoryAttributes();
    }

    protected void getFactoryAttributes() {
        FactoryResourceAttributesDocumentType factoryAttributes = null;
        this.verbose("Getting Factory Attributes ..");
        try {
            factoryAttributes = this.factory.getFactoryResourceAttributes().getFactoryResourceAttributesDocument();
        }
        catch (Exception e) {
            this.error("Couldn't get resource attributes", e);
            this.endProcessing();
        }
        this.printDetailed = this.getCommandLine().hasOption("l");
        if (this.printDetailed) {
            this.message(factoryAttributes.toString());
            return;
        }
        this.message("\n============ BESFactory Attributes ============\n");
        if (factoryAttributes.getCommonName() != null) {
            this.message("Common Name::: " + factoryAttributes.getCommonName());
        }
        if (factoryAttributes.getLongDescription() != null) {
            this.message("Description::: " + factoryAttributes.getLongDescription());
        }
        this.message("Total Number of Activities::: " + factoryAttributes.getTotalNumberOfActivities());
        this.printList("Naming Profile", factoryAttributes.getNamingProfileArray());
        this.printList("Supported Extension", factoryAttributes.getBESExtensionArray());
        this.message("Local Resource Manager::: " + factoryAttributes.getLocalResourceManagerType());
        BasicResourceAttributesDocumentType basicResource = factoryAttributes.getBasicResourceAttributesDocument();
        if (basicResource != null) {
            this.message("\n============ Resource Attributes ============\n");
            if (basicResource.getCPUArchitecture() != null) {
                this.message("CPU Architecture::: " + basicResource.getCPUArchitecture().getCPUArchitectureName());
            }
            if (basicResource.getCPUCount() > 0.0) {
                this.message("CPU Count::: " + basicResource.getCPUCount());
            }
            if (basicResource.getCPUSpeed() > 0.0) {
                this.message("CPU Speed::: " + basicResource.getCPUSpeed());
            }
        }
    }

    public String getDescription() {
        return "provides information about the UNICORE 6 BES Interface";
    }

    public String getName() {
        return "bes-list-att";
    }

    public void printList(String property, Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            String separator = arr.length > 1 ? "_" + (i + 1) : "";
            this.message(property + separator + "::: " + arr[i]);
        }
    }

    public String getCommandGroup() {
        return "OGSA-BES";
    }

    public QName getQName() {
        return BESFactory.BES_PORT;
    }

    public String getServiceDetails(EndpointReferenceType epr, IClientConfiguration sec) {
        try {
            StringBuilder sb = new StringBuilder();
            FactoryClient client = new FactoryClient(epr, sec);
            FactoryResourceAttributesDocumentType resDoc = client.getFactoryResourceAttributes().getFactoryResourceAttributesDocument();
            OperatingSystemTypeEnumeration.Enum osType = resDoc.getBasicResourceAttributesDocument().getOperatingSystem().getOperatingSystemType().getOperatingSystemName();
            sb.append(osType);
            double cpuCount = this.getCPUCount(resDoc);
            if (cpuCount > 0.0) {
                sb.append(", ").append(cpuCount).append(" CPU").append(cpuCount > 1.0 ? "s" : "");
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private double getCPUCount(FactoryResourceAttributesDocumentType resDoc) {
        return resDoc.getBasicResourceAttributesDocument().getCPUCount();
    }

    public String getServiceName() {
        return "BESFactory";
    }
}

