/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.bes.BESActionBase;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ListActivities
extends BESActionBase {
    boolean printUrlFlag;
    boolean printDetailed;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"long");
        OptionBuilder.withArgName((String)"Long Description");
        OptionBuilder.withDescription((String)"Long Description");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
    }

    @Override
    public void process() {
        super.process();
        this.listActivities();
    }

    protected void listActivities() {
        this.printDetailed = this.getCommandLine().hasOption("l");
        try {
            this.verbose("Getting job info...");
            GetFactoryAttributesDocumentResponseDocument response = this.factory.getFactoryAttributesDocument();
            EndpointReferenceType[] eprs = response.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray();
            if (eprs.length == 0) {
                this.message("No activities in BESFactory: " + this.factory.getUrl());
                return;
            }
            GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
            GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
            GetActivityStatusesResponseDocument resStats = null;
            if (this.printDetailed) {
                this.verbose("Printing jobs with status information...");
                gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
                gStatsType = gStatsDoc.addNewGetActivityStatuses();
                gStatsType.setActivityIdentifierArray(response.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray());
                resStats = this.factory.getActivityStatuses(gStatsDoc);
            }
            for (int i = 0; i < eprs.length; ++i) {
                if (this.printDetailed) {
                    if (resStats != null) {
                        GetActivityStatusResponseType getActStatResType = resStats.getGetActivityStatusesResponse().getResponseArray()[i];
                        String add = getActStatResType.getActivityIdentifier().getAddress().getStringValue();
                        String state = getActStatResType.getActivityStatus().getState().toString();
                        this.message(add + " -- " + state);
                        continue;
                    }
                    this.message("Couldn't find activity statuses");
                    continue;
                }
                this.message(eprs[i].getAddress().getStringValue());
            }
        }
        catch (Exception e) {
            this.error("Couldn't get Activity References", e);
            this.endProcessing(1);
        }
    }

    public String getDescription() {
        return "list jobs running on BES.";
    }

    public String getName() {
        return "bes-list-jobs";
    }

    public String getCommandGroup() {
        return "OGSA-BES";
    }
}

