/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.util.Builder;
import java.io.File;
import org.apache.xmlbeans.XmlException;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivityResponseType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BaseActionState
extends ActionBase {
    protected Builder builder;
    protected EndpointReferenceType activityEpr;
    protected FactoryClient factory;

    protected void initBuilder() {
        String arg = null;
        if (this.getCommandLine().getArgs().length > 1) {
            arg = this.getCommandLine().getArgs()[1];
        }
        if (arg == null) {
            this.error("Can't find job file.", null);
            this.endProcessing();
        }
        this.initFromCmdline(arg);
        this.buildFactory();
        String eprString = this.builder.getProperty("activity-epr");
        if (eprString == null) {
            this.error("Job EPR not found! Maybe <" + arg + "> has not been produced by UCC.", null);
            this.endProcessing();
        }
        try {
            this.activityEpr = EndpointReferenceType.Factory.parse((String)eprString);
            this.verbose("Job EPR OK.");
        }
        catch (Exception xe) {
            this.error("Error parsing job EPR", xe);
            this.endProcessing(1);
        }
    }

    private void initFromCmdline(String arg) {
        try {
            File job = new File(arg);
            if (job.exists()) {
                this.builder = new Builder(job);
                this.verbose("Read job from <" + arg + ">");
            } else {
                System.err.println("Couldn't read job file");
                this.printUsage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Can't use <" + arg + ">.");
            this.endProcessing();
        }
    }

    public void process() {
        super.process();
        this.initBuilder();
    }

    protected void terminate() {
        TerminateActivitiesResponseType termType = null;
        try {
            termType = this.factory.terminateActivity(this.activityEpr);
        }
        catch (UnknownActivityIdentifierFault e) {
            this.error("Couldn't find the specified activity. ", e);
            this.endProcessing();
        }
        StringBuffer sb = new StringBuffer();
        TerminateActivityResponseType tt = termType.getResponseArray()[0];
        if (tt.getTerminated()) {
            sb.append("Job is Cancelled.");
        } else if (tt.getFault() != null) {
            sb.append(termType.getResponseArray()[0].getFault().getFaultstring());
        } else {
            sb.append("Job will eventually be Cancelled.");
        }
        this.message(sb.toString());
    }

    protected void buildFactory() {
        String factoryStr = this.builder.getProperty("factory-epr");
        try {
            EndpointReferenceType factoryEpr = EndpointReferenceType.Factory.parse((String)factoryStr);
            this.verbose("Accessing Factory at : <" + factoryEpr.getAddress().getStringValue() + ">");
            this.factory = new FactoryClient(factoryEpr.getAddress().getStringValue(), factoryEpr, this.securityProperties);
        }
        catch (XmlException e) {
            this.error("Couldn't get factory epr", e);
            this.endProcessing(1);
        }
        catch (Exception e) {
            this.error("Couldn't get factory client", e);
            this.endProcessing(1);
        }
    }
}

