/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESFactoryLister
implements Iterable<FactoryClient> {
    private static final Logger logger = Logger.getLogger((String)BESFactoryLister.class.getName());
    private IRegistryQuery registry;
    private IClientConfiguration securityProperties;
    private List<FactoryClient> factoryList;

    public BESFactoryLister(IRegistryQuery registry, IClientConfiguration securityProperties) {
        this.registry = registry;
        this.securityProperties = securityProperties;
        this.factoryList = new ArrayList<FactoryClient>();
    }

    public List<FactoryClient> list() throws Exception {
        List eprs = this.registry.listAccessibleServices(BESFactory.BES_PORT);
        for (EndpointReferenceType e : eprs) {
            try {
                FactoryClient fClient = new FactoryClient(e.getAddress().getStringValue(), e, this.securityProperties);
                this.factoryList.add(fClient);
            }
            catch (Exception ex) {
                Log.logException((String)("Error connecting to BESFactory " + e.getAddress().getStringValue()), (Throwable)ex, (Logger)logger);
            }
        }
        return this.factoryList;
    }

    @Override
    public Iterator<FactoryClient> iterator() {
        try {
            return this.list().iterator();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

