/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.bes.BESFactoryLister;
import de.fzj.unicore.ucc.bes.BESUCCConstants;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Random;
import org.apache.commons.cli.OptionBuilder;
import org.apache.xmlbeans.XmlException;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESActionBase
extends ActionBase
implements BESUCCConstants {
    protected String siteName;
    protected FactoryClient factory;
    protected String siteUrl;

    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withArgName((String)"BesFactory Url");
        OptionBuilder.withDescription((String)"BESFactory Url");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
    }

    public void process() {
        block13: {
            super.process();
            Boolean contactRegistry = Boolean.parseBoolean(this.properties.getProperty("contact-registry"));
            if (!contactRegistry.booleanValue()) {
                this.verbose("Bypassing registry.");
                this.siteName = this.getOption("sitename", "s");
                this.siteUrl = null;
                if (this.siteName == null || this.siteName.length() < 1) {
                    this.message("Please provide the site name with -s option. examples bes.1|http://mybessite|Path to BES EPR file");
                    this.endProcessing(1);
                }
                try {
                    URL url1 = new URL(this.siteName);
                    if (!this.siteName.startsWith("file://")) {
                        this.contactBESByUrl(this.siteName);
                        break block13;
                    }
                    File f = new File(url1.getPath());
                    this.verbose("Checking file " + f.getPath());
                    this.validateFile(f);
                    this.contactBESByEPRFile(f);
                }
                catch (MalformedURLException e) {
                    if (this.siteName.startsWith("bes.")) {
                        this.siteUrl = this.properties.getProperty(this.siteName);
                        if (this.siteUrl == null || this.siteUrl.length() < 1) {
                            this.message("Either BES Url is null or misspelled. Please specify a valid BES Url..");
                            this.endProcessing(1);
                        }
                        try {
                            URL url = new URL(this.siteUrl);
                            if (this.siteUrl.startsWith("file://")) {
                                this.siteUrl = url.getPath();
                                throw new MalformedURLException();
                            }
                            this.contactBESByUrl(this.siteUrl);
                        }
                        catch (MalformedURLException e1) {
                            File f = new File(this.siteUrl);
                            this.validateFile(f);
                            this.contactBESByEPRFile(f);
                        }
                        break block13;
                    }
                    this.message("Couldn't reach the BES: '" + this.siteUrl + "' URL.");
                    this.message("Please specify a BES URL or name.");
                    this.endProcessing(1);
                }
            } else {
                super.initRegistryClient();
                try {
                    this.findBES();
                }
                catch (Exception ex) {
                    this.error("Can't find a BES factory.", ex);
                }
            }
        }
    }

    private void validateFile(File f) {
        if (f.isDirectory()) {
            this.error("BES EPR file path <" + this.siteUrl + "> is a directory. Please specify a valid BES EPR file path.", null);
            this.endProcessing(1);
        }
        if (!f.canRead() || !f.exists()) {
            this.error("BES EPR file path <" + this.siteUrl + "> doesn't exist or you don't have access privileges. " + "Please specify a valid EPR file path.", null);
            this.endProcessing(1);
        }
    }

    protected void contactBESByUrl(String siteUrl) {
        this.verbose("Contacting BES via Url " + siteUrl + " ..");
        EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
        eprt.addNewAddress().setStringValue(siteUrl);
        try {
            this.factory = new FactoryClient(siteUrl, eprt, this.securityProperties);
        }
        catch (Exception e) {
            this.error("Couldn't contact BES <" + siteUrl + ">", e);
            this.endProcessing(1);
        }
    }

    protected void contactBESByEPRFile(File eprFilePath) {
        this.verbose("Contacting BES via EPR file.");
        EndpointReferenceType eprt = null;
        try {
            eprt = EndpointReferenceType.Factory.parse((File)eprFilePath);
        }
        catch (XmlException e) {
            this.error("Error parsing BES EPR file.", e);
            this.endProcessing(1);
        }
        catch (IOException e) {
            this.error("Error loading BES EPR file.", e);
            this.endProcessing(1);
        }
        try {
            this.factory = new FactoryClient(eprt.getAddress().getStringValue(), eprt, this.securityProperties);
        }
        catch (Exception e) {
            this.error("Couldn't contact BES <" + eprt.getAddress().getStringValue() + ">", e);
            this.endProcessing(1);
        }
    }

    protected void findBES() throws Exception {
        List<FactoryClient> list = new BESFactoryLister(this.registry, this.securityProperties).list();
        int size = list.size();
        if (size > 0) {
            if (this.siteName != null) {
                for (FactoryClient f : list) {
                    if (!f.getEPR().getAddress().getStringValue().contains(this.siteName)) continue;
                    this.factory = f;
                    return;
                }
            } else {
                this.factory = list.get(new Random().nextInt(size));
            }
        } else {
            this.message("No BESFactory instance found in the registry.");
            this.endProcessing(1);
        }
    }

    protected void initRegistryClient() {
    }
}

