/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ucc.ccm;

import de.fzj.unicore.ucc.MessageWriter;
import eu.emi.security.authn.x509.helpers.KeyStoreHelper;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.ccm.ProfileHandler;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.ucc.ccm.CCMAction;
import eu.unicore.ucc.ccm.CCMException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import jline.ConsoleReader;
import org.apache.commons.io.FileUtils;
import xmlbeans.eu.unicore.ccm.internal.ClientProfileDocument;
import xmlbeans.eu.unicore.ccm.internal.TrustedCAType;

public class TrustUpdater {
    public static final String DEFAULT_CA = "demo ca for testing only";
    private char[] password;
    private MessageWriter parent;
    private String workingDir;

    public TrustUpdater(MessageWriter parent, String workingDir) {
        this.parent = parent;
        this.workingDir = workingDir;
    }

    public void processTrustedCAs(ClientProfileDocument.ClientProfile profile, boolean update, String propertiesFile) throws CCMException {
        List<X509Certificate> certs = this.fetchTrustedCAs(profile);
        if (certs.size() == 0) {
            return;
        }
        TruststoreProperties tsProps = this.initSecurityProperties(propertiesFile);
        TruststoreProperties.TruststoreType type = (TruststoreProperties.TruststoreType)tsProps.getEnumValue("type", TruststoreProperties.TruststoreType.class);
        if (type == TruststoreProperties.TruststoreType.keystore) {
            this.processKeystoreTS(profile, certs, update, tsProps);
        } else if (type == TruststoreProperties.TruststoreType.directory) {
            this.processDirectoryTS(profile, tsProps, certs);
        } else {
            this.parent.message("The currently set truststore type " + type + " is not supported by the " + "configuration utility. Therefore the trusted certificates from the profile WERE NOT INSTALLED.");
        }
    }

    private void processDirectoryTS(ClientProfileDocument.ClientProfile profile, TruststoreProperties tsParams, List<X509Certificate> certs) throws CCMException {
        List paths = tsParams.getListOfValues("directoryLocations.");
        String chosenPath = null;
        for (String path : paths) {
            int split;
            File f = new File(path);
            if (f.exists() || !path.contains(File.separator) || (split = path.lastIndexOf(File.separator)) == path.length()) continue;
            String suffix = path.substring(split + 1, path.length());
            f = new File(path = path.substring(0, split));
            if (!f.isDirectory() || !f.canWrite() || !suffix.equals("*") && !suffix.equals("*.*") && !suffix.equals("*.pem")) continue;
            chosenPath = path;
            break;
        }
        if (chosenPath == null) {
            throw new CCMException("Directory truststore must have at leas one writable directory configured, with a wildcard expression accepting files with the pem extension (e.g. '*.pem') in order to store downloaded certificates.");
        }
        this.addTrustedCAstoDir(certs, profile, new File(chosenPath));
    }

    private void processKeystoreTS(ClientProfileDocument.ClientProfile profile, List<X509Certificate> certs, boolean update, TruststoreProperties tsParams) throws CCMException {
        String password = tsParams.getValue("keystorePassword");
        if (password == null) {
            password = new String(this.password);
        }
        String truststore = tsParams.getValue("keystorePath");
        String type = tsParams.getValue("keystoreFormat");
        if (type == null) {
            try {
                type = KeystoreCredential.autodetectType((String)truststore, (char[])password.toCharArray());
            }
            catch (Exception e1) {
                throw new CCMException("Truststore keystore's type is not set and its autodetection failed. Try to set it.", e1);
            }
        }
        if (update) {
            CCMAction.backupFile(truststore, this.parent);
        } else {
            try {
                FileUtils.copyFileToDirectory((File)new File(truststore), (File)new File(this.workingDir));
                truststore = this.workingDir + File.separator + new File(truststore).getName();
            }
            catch (IOException e) {
                throw new CCMException("Can't copy the original truststore", e);
            }
        }
        KeyStore ts = this.loadTS(truststore, type, password.toCharArray());
        this.addTrustedCAsToKs(certs, profile, ts);
        this.saveTS(ts, truststore, password.toCharArray());
    }

    private KeyStore loadTS(String path, String type, char[] passwd) throws CCMException {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
            KeyStore ret = KeyStoreHelper.getInstance((String)type);
            ret.load(is, passwd);
            ((InputStream)is).close();
            return ret;
        }
        catch (GeneralSecurityException e) {
            throw new CCMException("Can't load the truststore " + path, e);
        }
        catch (IOException e) {
            throw new CCMException("Can't load the truststore " + path, e);
        }
    }

    private void saveTS(KeyStore ts, String path, char[] passwd) throws CCMException {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path));
            ts.store(os, passwd);
            ((OutputStream)os).close();
        }
        catch (GeneralSecurityException e) {
            throw new CCMException("Can't save the truststore " + path, e);
        }
        catch (IOException e) {
            throw new CCMException("Can't save the truststore " + path, e);
        }
    }

    private List<X509Certificate> fetchTrustedCAs(ClientProfileDocument.ClientProfile profile) throws CCMException {
        List certs;
        ProfileHandler handler = new ProfileHandler(profile);
        try {
            certs = handler.downloadCACerts();
        }
        catch (IOException e) {
            throw new CCMException("Can't download trusted CA certificates referenced in the profile", e);
        }
        return certs;
    }

    private void addTrustedCAsToKs(List<X509Certificate> certs, ClientProfileDocument.ClientProfile profile, KeyStore ks) throws CCMException {
        if (profile.getRemoveDefaults()) {
            try {
                if (ks.containsAlias(DEFAULT_CA)) {
                    ks.deleteEntry(DEFAULT_CA);
                }
            }
            catch (KeyStoreException e) {
                this.parent.error("Can't remove the default trusted CA", (Throwable)e);
            }
        }
        TrustedCAType[] trustedCAMeta = profile.getTrustedCAArray();
        for (int i = 0; i < certs.size(); ++i) {
            String alias = trustedCAMeta[i].getSuggestedLabel();
            X509Certificate cert = certs.get(i);
            try {
                String subject = X500NameUtils.getReadableForm((X500Principal)cert.getSubjectX500Principal());
                if (ks.getCertificateAlias(cert) != null) {
                    this.parent.verbose("Skipping trusted certificate " + subject + " as it is already present in the truststore.");
                    continue;
                }
                if (ks.containsAlias(alias)) {
                    int j = 1;
                    while (ks.containsAlias(alias + "_" + j)) {
                        ++j;
                    }
                    alias = alias + "_" + j;
                }
                this.parent.verbose("Will add CA " + subject + " under " + alias + " alias.");
                ks.setCertificateEntry(alias, cert);
                this.parent.message("Added a new trusted CA: " + cert.getSubjectX500Principal());
                continue;
            }
            catch (Exception e) {
                throw new CCMException("Can't add trusted CA certificate to the keystore", e);
            }
        }
    }

    private void addTrustedCAstoDir(List<X509Certificate> certs, ClientProfileDocument.ClientProfile profile, File directory) throws CCMException {
        TrustedCAType[] trustedCAMeta = profile.getTrustedCAArray();
        for (int i = 0; i < certs.size(); ++i) {
            String alias = trustedCAMeta[i].getSuggestedLabel();
            X509Certificate cert = certs.get(i);
            try {
                File certFile = new File(directory, alias + ".pem");
                int j = 1;
                while (certFile.exists()) {
                    certFile = new File(directory, alias + "_" + j + ".pem");
                }
                this.parent.verbose("Will save CA " + X500NameUtils.getReadableForm((X500Principal)cert.getSubjectX500Principal()) + " certificate to file " + certFile);
                FileOutputStream fos = new FileOutputStream(certFile);
                CertificateUtils.saveCertificate((OutputStream)fos, (X509Certificate)cert, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
                fos.close();
                this.parent.message("Added a new trusted CA: " + X500NameUtils.getReadableForm((X500Principal)cert.getSubjectX500Principal()));
                continue;
            }
            catch (Exception e) {
                throw new CCMException("Can't add trusted CA certificate to the keystore", e);
            }
        }
    }

    private TruststoreProperties initSecurityProperties(String propertiesFile) throws CCMException {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(propertiesFile));
        }
        catch (Exception e) {
            throw new CCMException("Can't load truststore", e);
        }
        TruststoreProperties sp = new TruststoreProperties(properties, null, this.getPasswordCallback(), "truststore.");
        return sp;
    }

    private PasswordCallback getPasswordCallback() {
        return new PasswordCallback(){

            public boolean ignoreProperties() {
                return false;
            }

            public char[] getPassword(String protectedArtifactType, String protectedArtifactDescription) {
                String r;
                TrustUpdater.this.parent.message("Please enter your " + protectedArtifactType + " (" + protectedArtifactDescription + ") password: ");
                try {
                    r = new ConsoleReader().readLine(new Character('*'));
                }
                catch (IOException e) {
                    return null;
                }
                r.trim();
                TrustUpdater.access$102(TrustUpdater.this, r.toCharArray());
                return r.toCharArray();
            }

            public boolean askForSeparateKeyPassword() {
                return false;
            }
        };
    }

    static /* synthetic */ char[] access$102(TrustUpdater x0, char[] x1) {
        x0.password = x1;
        return x1;
    }
}

