/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ucc.ccm;

import de.fzj.unicore.ucc.MessageWriter;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.ucc.ccm.CCMAction;
import eu.unicore.ucc.ccm.CCMException;
import eu.unicore.ucc.ccm.PropertiesFileHelper;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.FilePropertiesHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import xmlbeans.eu.unicore.ccm.internal.ClientProfileDocument;
import xmlbeans.eu.unicore.ccm.internal.PropertyExtType;
import xmlbeans.eu.unicore.ccm.internal.RegistryType;

public class PropertiesUpdater {
    public static String DEFAULT_HOST = "localhost";
    public static String DEFAULT_VSITE = "DEMO-SITE";
    private MessageWriter parent;
    private String workingDir;
    private boolean removeDefault;

    public PropertiesUpdater(MessageWriter reporter, String workingDir) {
        this.parent = reporter;
        this.workingDir = workingDir;
    }

    public void processRegistries(ClientProfileDocument.ClientProfile profile, String propertiesFile, boolean update) throws CCMException {
        this.removeDefault = profile.getRemoveDefaults();
        File propsFile = new File(propertiesFile);
        if (!propsFile.exists()) {
            this.parent.message("Properties file " + propertiesFile + " does not exist. " + "It will be created.");
            try {
                File parent = propsFile.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                propsFile.createNewFile();
            }
            catch (IOException e) {
                throw new CCMException("Can't create an empty properties file", e);
            }
        }
        if (update) {
            CCMAction.backupFile(propertiesFile, this.parent);
        } else {
            try {
                FileUtils.copyFileToDirectory((File)new File(propertiesFile), (File)new File(this.workingDir));
                propertiesFile = this.workingDir + File.separator + new File(propertiesFile).getName();
            }
            catch (IOException e) {
                throw new CCMException("Can't copy the original configuration", e);
            }
        }
        try {
            if (profile.isSetClientProperties()) {
                this.applyGenericProperties(propertiesFile, profile.getClientProperties().getPropertyArray());
            }
            RegistryType[] registries = profile.getRegistryArray();
            this.processRegistries(propertiesFile, registries);
            this.setupTruststoreSettings(propertiesFile);
        }
        catch (ConfigurationException e) {
            throw new CCMException("Can't update the  configuration", e);
        }
        catch (MalformedURLException e) {
            throw new CCMException("Can't update the configuration as one of registry URLs was invalid", e);
        }
        catch (IOException e) {
            throw new CCMException("Can't update the configuration as there is a I/O error", e);
        }
        catch (KeyStoreException e) {
            throw new CCMException("Can't update the configuration as there is a problem with setting up an empty truststore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CCMException("Can't update the configuration as there is a problem with setting up an empty truststore", e);
        }
        catch (CertificateException e) {
            throw new CCMException("Can't update the configuration as there is a problem with setting up an empty truststore", e);
        }
    }

    private void applyGenericProperties(String file, PropertyExtType[] props) throws ConfigurationException, IOException {
        if (props == null || props.length == 0) {
            return;
        }
        PropertiesFileHelper propsHelper = new PropertiesFileHelper(file);
        PropertiesConfiguration config = propsHelper.getPropertiesConfiguration();
        for (PropertyExtType property : props) {
            String propertyName = property.getName();
            if (config.containsKey(propertyName)) {
                if (property.getOverwrite()) {
                    this.parent.verbose("Overwriting an existing value of property " + propertyName + " (" + config.getString(propertyName) + ") to: " + property.getStringValue());
                    config.setProperty(property.getName(), (Object)property.getStringValue());
                    continue;
                }
                this.parent.verbose("Ignoring profile value of property " + propertyName + " (" + property.getStringValue() + ") and leaving the current value: " + config.getString(propertyName));
                continue;
            }
            this.parent.verbose("Adding a property " + propertyName + " with value: " + property.getStringValue());
            config.setProperty(property.getName(), (Object)property.getStringValue());
        }
        propsHelper.close();
    }

    private void setupTruststoreSettings(String file) throws ConfigurationException, IOException, CCMException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        PropertiesFileHelper propsHelper = new PropertiesFileHelper(file);
        PropertiesConfiguration config = propsHelper.getPropertiesConfiguration();
        String type = config.getString("truststore.type");
        if (type == null) {
            type = TruststoreProperties.TruststoreType.directory.toString();
            config.setProperty("truststore.type", (Object)type);
            propsHelper.close();
            propsHelper = new PropertiesFileHelper(file);
            config = propsHelper.getPropertiesConfiguration();
        }
        FilePropertiesHelper trustHelper = new FilePropertiesHelper("truststore.", file, TruststoreProperties.META, Log.getLogger((String)"unicore.configuration", this.getClass()));
        if (type.equals(TruststoreProperties.TruststoreType.keystore.toString())) {
            String ksType = trustHelper.getValue("keystoreFormat");
            ksType = ksType == null ? "jks" : ksType.toLowerCase();
            String ksPath = trustHelper.getValue("keystorePath");
            if (ksPath == null) {
                ksPath = this.workingDir + File.separator + "uccTruststore." + ksType;
                config.setProperty("truststore.keystorePath", (Object)ksPath);
                File ksFile = new File(ksPath);
                if (!ksFile.exists()) {
                    KeyStore ks = KeyStore.getInstance(ksType);
                    String tsPasswd = "the!client";
                    ks.store(new FileOutputStream(ksFile), tsPasswd.toCharArray());
                    config.setProperty("truststore.keystorePassword", (Object)tsPasswd);
                }
            }
        } else if (type.equals(TruststoreProperties.TruststoreType.directory.toString())) {
            List paths = trustHelper.getListOfValues("directoryLocations.");
            if (paths.size() == 0) {
                String p = this.workingDir + File.separator + "uccTruststore.d";
                config.setProperty("truststore.directoryLocations.", (Object)(p + File.separator + "*.*"));
                File dirFile = new File(p);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                } else if (!dirFile.isDirectory()) {
                    throw new CCMException("The default path which is used for directory type truststore is occupied by a file: " + dirFile);
                }
            }
        } else if (!type.equals(TruststoreProperties.TruststoreType.openssl.toString())) {
            throw new CCMException("Unknown type of truststore is configured: " + type);
        }
        propsHelper.close();
    }

    private void processRegistries(String file, RegistryType[] registries) throws ConfigurationException, IOException {
        if (registries == null || registries.length == 0) {
            this.parent.verbose("No registries defined in the configuration profile, skipping an update of properties.");
            return;
        }
        LinkedHashMap<URL, RegistryType> newRegs = new LinkedHashMap<URL, RegistryType>();
        for (RegistryType reg : registries) {
            URL u = new URL(reg.getAddress());
            newRegs.put(u, reg);
        }
        PropertiesFileHelper propsHelper = new PropertiesFileHelper(file);
        PropertiesConfiguration config = propsHelper.getPropertiesConfiguration();
        String registryURL = config.getString("registry");
        String[] urls = registryURL != null ? registryURL.split("[, ]") : new String[]{};
        StringBuilder newRegistries = new StringBuilder();
        boolean first = true;
        for (String existing : urls) {
            if (existing.trim().equals("")) continue;
            URL rURL = new URL(existing);
            if (this.removeDefault && rURL.getHost().equals(DEFAULT_HOST) && rURL.getPath().contains(DEFAULT_VSITE)) {
                this.parent.verbose("Removing the default registry: " + existing);
                continue;
            }
            if (newRegs.containsKey(rURL)) {
                this.parent.verbose("Registry " + rURL + " already present.");
                newRegs.remove(rURL);
            }
            if (!first) {
                newRegistries.append(" ");
            }
            newRegistries.append(existing);
            first = false;
        }
        Iterator newOnes = newRegs.keySet().iterator();
        while (newOnes.hasNext()) {
            if (!first) {
                newRegistries.append(" ");
            }
            String toAdd = ((URL)newOnes.next()).toString();
            newRegistries.append(toAdd);
            first = false;
            this.parent.message("Added a new registry: " + toAdd);
        }
        config.setProperty("registry", (Object)newRegistries.toString());
        propsHelper.close();
    }
}

