/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ucc.ccm;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class PropertiesFileHelper {
    public static final String MAGIC_END = "END.ARTIFICIAL.PROPERTY = END.ARTIFICIAL.PROPERTY";
    private String file;
    private PropertiesConfiguration config;

    public PropertiesFileHelper(String file) {
        this.file = file;
    }

    public PropertiesConfiguration getPropertiesConfiguration() throws IOException, ConfigurationException {
        boolean addNL = !this.checkNLAtEnd();
        BufferedWriter fw = new BufferedWriter(new FileWriter(this.file, true));
        if (addNL) {
            fw.newLine();
        }
        fw.write(MAGIC_END);
        fw.newLine();
        fw.close();
        this.config = new PropertiesConfiguration();
        this.config.setDelimiterParsingDisabled(true);
        this.config.setFileName(this.file);
        this.config.load();
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNLAtEnd() throws IOException {
        String lineSep = System.getProperty("line.separator");
        byte[] sepBytes = lineSep.getBytes();
        int sepLen = sepBytes.length;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, "r");
            if (raf.length() - (long)sepLen - 1L < 0L) {
                boolean bl = false;
                return bl;
            }
            raf.seek(raf.length() - (long)sepLen - 1L);
            byte[] buf = new byte[sepLen];
            raf.read(buf);
            for (int i = 0; i < sepLen; ++i) {
                if (buf[i] == sepBytes[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        return true;
    }

    public void close() throws IOException, ConfigurationException {
        this.config.save();
        this.cleanupSlashes(this.file);
    }

    private void cleanupSlashes(String inputFile) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        CharArrayWriter wr = new CharArrayWriter(10240);
        String lineSep = System.getProperty("line.separator");
        while ((line = br.readLine()) != null) {
            int i;
            if (line.equals(MAGIC_END)) continue;
            char[] chars = line.toCharArray();
            for (i = 0; i < chars.length - 1; ++i) {
                if (chars[i] == '\\') {
                    if (chars[i + 1] == '\\') {
                        ++i;
                        continue;
                    }
                    if (chars[i + 1] == '/') {
                        wr.append('/');
                        ++i;
                        continue;
                    }
                }
                wr.append(chars[i]);
            }
            if (i < chars.length) {
                wr.append(chars[i]);
            }
            wr.append(lineSep);
        }
        br.close();
        BufferedWriter bw = new BufferedWriter(new FileWriter(inputFile));
        bw.write(wr.toCharArray());
        bw.close();
    }
}

