/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ucc.ccm;

import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCC;
import eu.unicore.ccm.ProfileHandler;
import eu.unicore.ucc.ccm.CCMAction;
import eu.unicore.ucc.ccm.CCMException;
import eu.unicore.ucc.ccm.PropertiesFileHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import xmlbeans.eu.unicore.ccm.internal.ClientProfileDocument;
import xmlbeans.eu.unicore.ccm.internal.UCCExtensionType;

public class PluginsUpdater {
    private MessageWriter parent;
    private String workingDir;
    public static String unitTestVersion;

    public PluginsUpdater(MessageWriter parent, String workingDir) {
        this.parent = parent;
        this.workingDir = workingDir;
    }

    public void processPlugins(ClientProfileDocument.ClientProfile profile, String extensionsFile, boolean update) throws CCMException {
        File tD;
        String targetDirectory;
        UCCExtensionType[] extensions = profile.getUccExtensionArray();
        if (extensions == null || extensions.length == 0) {
            this.parent.verbose("UCC extensions are not defined in the configuration.");
            return;
        }
        if (update) {
            CCMAction.backupFile(extensionsFile, this.parent);
            targetDirectory = System.getProperty("user.home") + File.separator + ".ucc" + File.separator + "lib";
            tD = new File(targetDirectory);
            if (!tD.exists()) {
                tD.mkdirs();
            } else if (!tD.isDirectory()) {
                throw new CCMException("Additional plugins library folder " + tD.getAbsolutePath() + " is not a directory!");
            }
        } else {
            try {
                FileUtils.copyFileToDirectory((File)new File(extensionsFile), (File)new File(this.workingDir));
                extensionsFile = this.workingDir + File.separator + new File(extensionsFile).getName();
            }
            catch (IOException e) {
                throw new CCMException("Can't copy the original extensions file", e);
            }
            tD = new File(this.workingDir + File.separator + "lib");
            tD.mkdir();
            targetDirectory = tD.getAbsolutePath();
        }
        this.parent.verbose("Will download plugins to: " + targetDirectory);
        this.parent.verbose("Will install new commands from plugins in: " + extensionsFile);
        for (UCCExtensionType extension : extensions) {
            this.handleExtension(extension, targetDirectory, extensionsFile);
        }
    }

    private void handleExtension(UCCExtensionType extension, String targetPath, String exFile) throws CCMException {
        if (!this.compareVersion(extension.getMinClientVersion(), extension.getMaxClientVersion(), extension.getPluginName())) {
            return;
        }
        try {
            String fileName = extension.getPluginName() + "-" + extension.getPluginVersion() + ".jar";
            File target = new File(targetPath, fileName);
            if (target.exists()) {
                this.parent.message("Skipping installation of plugin " + extension.getPluginName() + " as file " + target + " already exists.");
                return;
            }
            ProfileHandler.downloadToFile((String)extension.getPluginURL(), (String)target.toString());
            this.parent.message("Installed a new plugin " + target);
        }
        catch (IOException e) {
            throw new CCMException("Can not download an extension library, which is specified in the profile", e);
        }
        String[] commands = extension.getCommandArray();
        PropertiesFileHelper propsHelper = new PropertiesFileHelper(exFile);
        try {
            PropertiesConfiguration config = propsHelper.getPropertiesConfiguration();
            for (String command : commands) {
                String[] cmd = command.split("=");
                if (cmd.length != 2) {
                    throw new CCMException("Command definition '" + command + "' is invalid, should contain one '='.");
                }
                if (config.containsKey(cmd[0])) {
                    this.parent.message("Skipping installation of the command " + command + " as a command with the same name is already defined.");
                    continue;
                }
                config.addProperty(cmd[0], (Object)cmd[1]);
                this.parent.message("Added a new command: " + cmd[0]);
            }
            propsHelper.close();
        }
        catch (ConfigurationException e) {
            throw new CCMException("Can't update the  configuration", e);
        }
        catch (IOException e) {
            throw new CCMException("Can't update the configuration as there is a I/O error", e);
        }
    }

    private boolean compareVersion(String min, String max, String name) throws CCMException {
        String version = UCC.class.getPackage().getImplementationVersion();
        if (UCC.unitTesting) {
            version = unitTestVersion;
        }
        if (version == null) {
            throw new CCMException("UCC implementation version is not known");
        }
        DefaultArtifactVersion minVersion = new DefaultArtifactVersion(min);
        DefaultArtifactVersion maxVersion = new DefaultArtifactVersion(max);
        DefaultArtifactVersion curVersion = new DefaultArtifactVersion(version);
        if (curVersion.compareTo((ArtifactVersion)minVersion) == -1 || curVersion.compareTo((ArtifactVersion)maxVersion) == 1) {
            this.parent.message("Ignoring instalation of extension " + name + " as it is not supporting this UCC version. Supported versions are from " + min + " to " + max + " while the version of UCC is: " + version);
            return false;
        }
        return true;
    }

    public static String getMainExtensionsFile() {
        String filename = System.getProperty("ucc.extensions");
        if (filename != null) {
            return filename;
        }
        filename = System.getProperty("user.home") + File.separator + ".ucc" + File.separator + "extensions";
        return filename;
    }
}

