/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ucc.ccm;

import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import eu.unicore.ccm.CCMManager;
import eu.unicore.ucc.ccm.CCMException;
import eu.unicore.ucc.ccm.PluginsUpdater;
import eu.unicore.ucc.ccm.PropertiesUpdater;
import eu.unicore.ucc.ccm.TrustUpdater;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import javax.net.ssl.SSLHandshakeException;
import jline.ConsoleReader;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.XmlException;
import xmlbeans.eu.unicore.ccm.internal.ClientProfileDocument;

public class CCMAction
extends Command {
    public static final String OPT_NONINTERACTIVE_LONG = "assumeyes";
    public static final String OPT_NONINTERACTIVE = "b";
    public static final String OPT_UPDATE_LONG = "updateexisting";
    public static final String OPT_UPDATE = "u";

    public String getName() {
        return "download-config";
    }

    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"configuration");
        OptionBuilder.withDescription((String)"Properties file containing your preferences. By default, a file '<userhome>/.ucc/preferences' is checked.");
        OptionBuilder.withArgName((String)"Properties");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"c"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_NONINTERACTIVE_LONG);
        OptionBuilder.withDescription((String)"Non interactive mode, all confirmations are automatically accepted");
        OptionBuilder.withArgName((String)"AssumeYes");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_NONINTERACTIVE));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_UPDATE_LONG);
        OptionBuilder.withDescription((String)"Update the (currently used) configuration of the client. If this option is not selected then downloaded configuration will be saved in a separate directory.");
        OptionBuilder.withArgName((String)"UpdateExisting");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)OPT_UPDATE));
    }

    public String getSynopsis() {
        return "Downloads a configuration profile for your client appliaction. Such configuration profile may be published by your grid infrastructure provider to quickly connect to the resouces. You must provide at least a URL of the profile and a fingerprint of a server's certificate which is hosting the profile.";
    }

    public String getDescription() {
        return "downloads configuration profile for this client";
    }

    public String getArgumentList() {
        return "<https profile URL> <server's certificate SHA1 fingerprint>";
    }

    public String getCommandGroup() {
        return "General";
    }

    public void process() {
        super.process();
        if (this.getCommandLine().getArgs().length < 3) {
            this.message("Please provide a profile's URL and a fingerprint arguments.");
            this.printUsage();
            this.endProcessing(2);
        }
        String address = this.getCommandLine().getArgs()[1];
        String fingerprint = this.getCommandLine().getArgs()[2];
        if (this.propertiesFile == null) {
            this.error("Properties file is undefined", null);
            this.endProcessing(2);
        }
        CCMManager ccmManager = new CCMManager();
        ClientProfileDocument.ClientProfile profile = null;
        try {
            profile = ccmManager.download(address, fingerprint);
        }
        catch (SSLHandshakeException e) {
            this.error("The profile can not be downloaded from the server, as the SSL connection can not be verified: " + e.getMessage(), e);
            this.endProcessing(2);
        }
        catch (IOException e) {
            this.error("There was a communication problem", e);
            this.endProcessing(2);
        }
        catch (XmlException e) {
            this.error("Profile was downloaded but is invalid", e);
            this.endProcessing(2);
        }
        catch (Exception e) {
            this.error("Error downloading a profile", e);
            this.endProcessing(2);
        }
        boolean update = this.getBooleanOption(OPT_UPDATE_LONG, OPT_UPDATE);
        boolean assumeYes = this.getBooleanOption(OPT_NONINTERACTIVE_LONG, OPT_NONINTERACTIVE);
        this.confirmInstallation(profile, update, assumeYes);
        String targetDirName = null;
        if (!update) {
            String baseDir = this.output.getAbsolutePath() + File.separator + "clientConfiguration-" + profile.getName();
            targetDirName = CCMAction.findUnusedName(baseDir);
            File targetDir = new File(targetDirName);
            if (!targetDir.mkdir()) {
                this.error("Error creating the working directory " + targetDirName + " for the downloaded configuration.", null);
                this.endProcessing(2);
            }
            this.verbose("Using " + targetDirName + " as a target directory");
        }
        PropertiesUpdater propertiesUtil = new PropertiesUpdater((MessageWriter)this, targetDirName);
        PluginsUpdater pluginsUtil = new PluginsUpdater((MessageWriter)this, targetDirName);
        TrustUpdater trustUtil = new TrustUpdater((MessageWriter)this, targetDirName);
        try {
            this.checkAuthnMethod();
            propertiesUtil.processRegistries(profile, this.propertiesFile.getAbsolutePath(), update);
            trustUtil.processTrustedCAs(profile, update, this.propertiesFile.getAbsolutePath());
            pluginsUtil.processPlugins(profile, PluginsUpdater.getMainExtensionsFile(), update);
        }
        catch (CCMException e) {
            this.error(e.getMessage(), e.getCause());
            this.endProcessing(2);
        }
        this.message("");
        if (update) {
            this.message("The configuration profile '" + profile.getName() + "' was successfully loaded. Note that in case of usage of " + "UCC shell you must restart the client to apply changes.");
        } else {
            this.message("The configuration profile '" + profile.getName() + "' was successfully stored in the '" + targetDirName + "' directory. You can review this configuration and" + " use it instead of your existing one.");
        }
    }

    private void confirmInstallation(ClientProfileDocument.ClientProfile profile, boolean update, boolean assumeYes) {
        this.message("Using this utility you can download a configuration for your UNICORE client software.");
        this.message("");
        this.message("The client's configuration is usually prepared and distributed by grid middleware providers. The configuration may be created for both production and tutorial or test installations. The data neccessary to fetch the configuration should be provided to you by your infrastructure provider: typically in support materials distributed in paper form or on on-line website");
        this.message("");
        this.message("SECURITY WARNING: it is crucial to install the client's configuration only from the trusted source, as installation of a malicious configuration effectively makes your client insecure. Therefore you can only download the configuration from a server after providing its fingerprint code. However you must be especially careful from what source you get the fingerprint code: it should be provided to you from a trusted people directly (e.g. during a live tutorial) or distributed on a trusted web site, i.e. the web site providing the code should be accessed using https:// address and your browser SHOULD NOT display any security warnings when accessing it.");
        this.message("");
        if (update) {
            this.message("The currently used configuation will be updated after being backed up.");
        }
        if (!assumeYes) {
            try {
                String line = new ConsoleReader().readLine("Are you sure that you want to continue? [N] ");
                if (!line.startsWith("y") && !line.startsWith("Y")) {
                    this.message("Exiting on user's request.");
                    this.endProcessing();
                }
            }
            catch (IOException e) {
                this.error("Can't read user's answer", e);
                this.endProcessing(2);
            }
        }
    }

    private static String findUnusedName(String base) {
        String file = base;
        int i = 1;
        while (new File(file).exists()) {
            file = base + "." + i++;
        }
        return file;
    }

    public static void backupFile(String original, MessageWriter writer) throws CCMException {
        DateFormat dt = DateFormat.getDateTimeInstance(3, 3);
        String time = dt.format(new Date());
        time = time.replace(' ', '_');
        String backupBase = original + "_backup_" + time;
        String backupFile = CCMAction.findUnusedName(backupBase);
        File origF = new File(original);
        File targetF = new File(backupFile);
        try {
            FileUtils.copyFile((File)origF, (File)targetF);
        }
        catch (IOException e) {
            throw new CCMException("Can't backup the " + original + " file", e);
        }
        if (writer != null) {
            writer.message("Created a backup of the original file: " + original + " named: " + backupFile);
        }
    }

    private void checkAuthnMethod() throws CCMException {
        String authNMethod = this.getOption("authenticationMethod", "k", "X509");
        if (!authNMethod.equals("X509")) {
            throw new CCMException("Configuration setup can be performed only when the default X509 authentication method is used.");
        }
    }
}

