/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.server.ACLHandler;
import eu.unicore.uftp.server.ServerThread;
import eu.unicore.uftp.server.UFTPTransferRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class UFTPServer
implements Runnable {
    private static final Logger logger = Logger.getLogger(UFTPServer.class);
    private static String VER = UFTPServer.class.getPackage().getImplementationVersion();
    public static final int SYNERR = 1;
    public static final int HOSTERR = 2;
    public static final int THREADERR = 3;
    public static final int CMDSOCKERR = 4;
    public static final int BACKLOG = 50;
    public static final String STOPSTRING = "stop";
    private final InetAddress cmdip;
    private final InetAddress srvip;
    private final int cmdport;
    private final int srvport;
    int timeout = 5000;
    int authtimeout = 5000;
    int jobReadTimeout = 5000;
    int maxStreams = 8;
    int maxControlConnectionsPerClient = 16;
    int bufferSize = 131072;
    private ServerThread svrThread;
    private volatile boolean stopped = false;
    private final boolean useSSL;
    private ACLHandler acl;

    public UFTPServer(InetAddress cmdip, int cmdport, InetAddress srvip, int srvport) throws IOException {
        this.cmdip = cmdip;
        this.cmdport = cmdport;
        this.srvip = srvip;
        this.srvport = srvport;
        this.initSSLProperties();
        boolean bl = this.useSSL = System.getProperty("javax.net.ssl.keyStore") != null;
        if (this.useSSL) {
            this.checkSSL();
            File aclFile = new File(System.getProperty("uftpd.acl", "conf/uftpd.acl"));
            this.acl = new ACLHandler(aclFile);
        }
    }

    private void initSSLProperties() throws IOException {
        String file = System.getProperty("uftpd-ssl.conf");
        if (file != null) {
            File sslProps = new File(file);
            if (!sslProps.exists()) {
                throw new IOException("SSL properties file " + file + " does not exist!");
            }
            logger.info((Object)("Loading SSL settings from " + file));
            Properties p = new Properties();
            p.load(new FileInputStream(sslProps));
            System.getProperties().putAll((Map<?, ?>)p);
        }
    }

    private void checkSSL() throws IOException {
        String trustStore;
        String keyStore = System.getProperty("javax.net.ssl.keyStore");
        logger.info((Object)("Enabling SSL, using keystore = " + keyStore));
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        if (keyStorePassword == null) {
            keyStorePassword = this.getFromCommandline();
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
        if ((trustStore = System.getProperty("javax.net.ssl.trustStore")) == null) {
            logger.warn((Object)"No truststore defined, will use Java system truststore.");
        } else {
            logger.info((Object)("Using truststore  = " + trustStore));
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            if (trustStorePassword == null && keyStore.equals(trustStore)) {
                System.setProperty("javax.net.ssl.trustStorePassword", keyStorePassword);
            }
        }
    }

    private String getFromCommandline() {
        System.out.println("Please enter the keystore password:");
        return new String(System.console().readPassword());
    }

    @Override
    public void run() {
        try {
            this.svrThread = new ServerThread(this.srvip, this.srvport, 50, this.maxStreams);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.svrThread.setTimeout(this.timeout);
        this.svrThread.setAuthTimeout(this.authtimeout);
        this.svrThread.setMaxControlConnectionsPerClient(this.maxControlConnectionsPerClient);
        this.svrThread.setBufferSize(this.bufferSize);
        this.svrThread.start();
        logger.info((Object)("UFTPD Listener server socket started on " + this.srvip.getHostName() + ":" + this.srvport));
        ServerSocket cmdSocket = null;
        try {
            cmdSocket = this.createCommandSocket();
            logger.info((Object)("UFTPD Command server socket started on " + this.cmdip.getHostName() + ":" + this.cmdport));
        }
        catch (IOException e) {
            logger.error((Object)"Error starting command socket.", (Throwable)e);
            System.exit(4);
        }
        logger.info((Object)("Maximum streams per client: " + this.maxStreams));
        logger.info((Object)("File buffer size per client: " + this.bufferSize + " kb."));
        while (!this.stopped) {
            Socket jobSocket = null;
            try {
                jobSocket = cmdSocket.accept();
                logger.info((Object)("New control connection from " + jobSocket.getInetAddress()));
                jobSocket.setSoTimeout(this.jobReadTimeout);
                if (this.useSSL) {
                    X500Principal x = (X500Principal)((SSLSocket)jobSocket).getSession().getPeerPrincipal();
                    this.acl.checkAccess(x.getName());
                }
                JobConnectionWorker jcw = new JobConnectionWorker(jobSocket, this.svrThread);
                Utils.getExecutor().execute(jcw);
            }
            catch (RejectedExecutionException ree) {
                try {
                    jobSocket.close();
                }
                catch (Exception ex) {
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error receiving job", (Throwable)e);
                try {
                    jobSocket.close();
                }
                catch (Exception ex) {
                }
            }
            catch (AuthorizationFailureException e) {
                logger.info((Object)"Access to command port denied", (Throwable)e);
                try {
                    jobSocket.close();
                }
                catch (Exception ex) {}
            }
        }
        logger.info((Object)"Exiting UFTP server.");
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthtimeout() {
        return this.authtimeout;
    }

    public void setAuthtimeout(int authtimeout) {
        this.authtimeout = authtimeout;
    }

    public void stop() {
        if (!this.stopped) {
            if (this.svrThread != null) {
                try {
                    this.svrThread.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Error stopping", (Throwable)ex);
                }
                this.svrThread.interrupt();
            }
            this.stopped = true;
        }
    }

    private ServerSocket createCommandSocket() throws IOException {
        if (this.useSSL) {
            return this.createSecureCommandSocket();
        }
        logger.info((Object)"*****");
        logger.info((Object)"*****   WARNING:");
        logger.info((Object)"****    Using a plain-text socket for receiving commands.");
        logger.info((Object)"****    On production systems you should enable SSL!");
        logger.info((Object)"****    Consult the UFTP manual for details.");
        logger.info((Object)"*****");
        return new ServerSocket(this.cmdport, 50, this.cmdip);
    }

    private SSLServerSocket createSecureCommandSocket() throws IOException {
        logger.info((Object)"Creating SSL socket for receiving commands.");
        ServerSocketFactory f = SSLServerSocketFactory.getDefault();
        SSLServerSocket s = (SSLServerSocket)f.createServerSocket(this.cmdport, 50, this.cmdip);
        s.setNeedClientAuth(true);
        return s;
    }

    public static void main(String[] args) {
        Options options = UFTPServer.createOptions();
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            System.out.println();
            UFTPServer.printUsage(options);
            System.exit(1);
        }
        UFTPServer.printHeader();
        InetAddress cmdip = null;
        InetAddress srvip = null;
        int cmdport = 0;
        int srvport = 0;
        UFTPServer server = null;
        try {
            cmdip = InetAddress.getByName(line.getOptionValue("c"));
            cmdport = Integer.parseInt(line.getOptionValue("p"));
            srvip = InetAddress.getByName(line.getOptionValue("l"));
            srvport = Integer.parseInt(line.getOptionValue("L"));
            server = new UFTPServer(cmdip, cmdport, srvip, srvport);
            server.maxStreams = Integer.parseInt(line.getOptionValue("m", "8"));
            server.bufferSize = Integer.parseInt(line.getOptionValue("b", "128")) * 1024;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println();
            UFTPServer.printUsage(options);
            System.exit(1);
        }
        server.run();
    }

    public static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"listen-host");
        OptionBuilder.withDescription((String)"Hostname of the listen socket");
        OptionBuilder.withArgName((String)"Listen host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"listen-port");
        OptionBuilder.withDescription((String)"Port of the listen socket");
        OptionBuilder.withArgName((String)"Listen host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"L"));
        OptionBuilder.withLongOpt((String)"command-host");
        OptionBuilder.withDescription((String)"Hostname of the command socket");
        OptionBuilder.withArgName((String)"Command host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"command-port");
        OptionBuilder.withDescription((String)"Port of the command socket");
        OptionBuilder.withArgName((String)"Command port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"max-parallel");
        OptionBuilder.withDescription((String)"Limit on the number of parallel streams per client (default: 8)");
        OptionBuilder.withArgName((String)"Stream limit");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"buffersize");
        OptionBuilder.withDescription((String)"Buffer size in kbytes for reading/writing files (default 128)");
        OptionBuilder.withArgName((String)"bufferSize");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"b"));
        return options;
    }

    public static void printHeader() {
        if (VER == null) {
            VER = "DEVELOPMENT";
        }
        String message = "**** UFTPD Version " + VER + " starting";
        logger.info((Object)message);
    }

    public static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "UFTPD [OPTIONS]" + System.getProperty("line.separator");
        formatter.printHelp(syntax, options);
    }

    public static class JobConnectionWorker
    implements Runnable {
        final Socket jobSocket;
        final ServerThread serverThread;

        public JobConnectionWorker(Socket jobSocket, ServerThread serverThread) {
            this.jobSocket = jobSocket;
            this.serverThread = serverThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.jobSocket.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null && line.length() != 0 && !"END".equals(line)) {
                    sb.append(line + "\n");
                }
                String jobString = sb.toString();
                logger.debug((Object)("New request: " + jobString));
                try {
                    UFTPTransferRequest j = new UFTPTransferRequest(jobString);
                    this.serverThread.addJob(j);
                    this.writeResponse("OK", this.jobSocket.getOutputStream());
                }
                catch (Exception e) {
                    logger.error((Object)("Invalid job: " + jobString), (Throwable)e);
                }
            }
            catch (IOException ioe) {
                logger.info((Object)"Error processing job connection.", (Throwable)ioe);
            }
            finally {
                try {
                    this.jobSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        void writeResponse(String msg, OutputStream os) throws IOException {
            OutputStreamWriter ow = new OutputStreamWriter(os, "UTF-8");
            ow.write(msg + "\n");
            ow.flush();
        }
    }
}

