/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.jparss;

import eu.unicore.uftp.jparss.PConfig;
import eu.unicore.uftp.jparss.PReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PInputStream
extends InputStream {
    private InputStream[] inputs_ = null;
    private int seq_ = -1;
    private PReader[] readers_ = null;
    private boolean done_ = false;
    private int readCount_ = 0;
    private boolean[] status_ = null;
    private int[] readLens_ = null;

    public PInputStream(InputStream[] streams) {
        int i;
        this.inputs_ = new InputStream[streams.length];
        this.status_ = new boolean[streams.length];
        this.readLens_ = new int[streams.length];
        for (i = 0; i < streams.length; ++i) {
            this.inputs_[i] = streams[i];
            this.status_[i] = true;
            this.readLens_[i] = 0;
        }
        if (PConfig.usethreads) {
            Thread worker = null;
            this.readers_ = new PReader[this.inputs_.length];
            for (i = 0; i < this.inputs_.length; ++i) {
                this.readers_[i] = new PReader(this, this.inputs_[i], i, this.inputs_.length);
                worker = new Thread(this.readers_[i]);
                worker.start();
            }
        }
    }

    @Override
    public void close() throws IOException {
        int i;
        if (this.inputs_ == null) {
            throw new IOException("No internal input streams.");
        }
        byte[] tbuf = new byte[4];
        if (PConfig.usethreads) {
            this.done_ = true;
            for (i = 0; i < this.readers_.length; ++i) {
                this.readers_[i].set(tbuf, 0, 0);
            }
        }
        for (i = 0; i < this.inputs_.length; ++i) {
            this.inputs_[i].close();
        }
    }

    public synchronized void setSeq(int seq) {
        this.seq_ = seq;
    }

    public synchronized int getSeq() {
        return this.seq_;
    }

    @Override
    public int read() throws IOException {
        byte[] header = new byte[16];
        DataInputStream headerStream = new DataInputStream(new ByteArrayInputStream(header));
        DataInputStream istream = null;
        int value = 0;
        for (int i = 0; i < this.inputs_.length; ++i) {
            istream = new DataInputStream(this.inputs_[i]);
            try {
                istream.readFully(header);
            }
            catch (EOFException ee) {
                System.err.println("PInput read: Output stream closed connection");
                throw new IOException("Connection closed");
            }
            catch (IOException e) {
                throw e;
            }
            short magic = headerStream.readShort();
            short pos = headerStream.readShort();
            int seq = headerStream.readInt();
            int totalnum = headerStream.readInt();
            int numtoread = headerStream.readInt();
            if (PConfig.debug) {
                System.out.println("PInput read: Received header: magic: " + Integer.toHexString(magic) + " stream position: " + String.valueOf(pos) + " seq: " + String.valueOf(seq) + " number to read: " + String.valueOf(numtoread));
            }
            if (magic != -12609) {
                throw new IOException("magic number mismatch");
            }
            if (pos < 0 || pos >= this.inputs_.length) {
                throw new IOException("Stream position mismatch");
            }
            if (seq < 0) {
                throw new IOException("Sequence number error");
            }
            if (totalnum != 1) {
                throw new IOException("Total byte number error");
            }
            if (numtoread != 0 && numtoread != 1) {
                throw new IOException("Number to read receiving error");
            }
            int expseq = this.seq_;
            if (expseq == -1) {
                this.seq_ = seq;
            } else if (expseq != seq) {
                throw new IOException("Sequence number mismatch");
            }
            if (numtoread != 1) continue;
            value = this.inputs_[i].read();
        }
        ++this.seq_;
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytes = 0;
        bytes = this.read(b, 0, b.length);
        return bytes;
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (PConfig.usethreads) {
            return this.readMultiThreaded(b, off, length);
        }
        byte[] header = new byte[16];
        DataInputStream istream = null;
        ByteArrayInputStream thstream = new ByteArrayInputStream(header);
        DataInputStream headerStream = new DataInputStream(thstream);
        int value = 0;
        for (int i = 0; i < this.inputs_.length; ++i) {
            istream = new DataInputStream(this.inputs_[i]);
            try {
                istream.readFully(header);
            }
            catch (EOFException ee) {
                return -1;
            }
            catch (IOException e) {
                throw e;
            }
            thstream.reset();
            short magic = headerStream.readShort();
            short pos = headerStream.readShort();
            int seq = headerStream.readInt();
            int totalnum = headerStream.readInt();
            int numtoread = headerStream.readInt();
            if (PConfig.debug) {
                System.out.println("PInput read: Reader[" + String.valueOf(i) + "] Received header: magic: " + Integer.toHexString(magic) + " stream position: " + String.valueOf(pos) + " seq: " + String.valueOf(seq) + " number to read: " + String.valueOf(numtoread));
            }
            if (magic != -12609) {
                throw new IOException("magic number mismatch");
            }
            if (pos < 0 || pos >= this.inputs_.length) {
                throw new IOException("Stream position mismatch");
            }
            if (seq < 0) {
                throw new IOException("Sequence number error");
            }
            if (totalnum < 0 || totalnum > length) {
                throw new IOException("Total byte number error: got " + totalnum);
            }
            if (numtoread < 0) {
                throw new IOException("Number to read receiving error");
            }
            int expseq = this.getSeq();
            if (expseq == -1) {
                this.setSeq(seq);
            } else if (expseq != seq) {
                throw new IOException("Sequence number mismatch");
            }
            int chunk = totalnum / this.inputs_.length;
            int toffset = off + pos * chunk;
            int tlen = i == this.inputs_.length - 1 ? length - i * chunk : chunk;
            if (numtoread > tlen) {
                throw new IOException("Not enough buffer size");
            }
            if (PConfig.debug) {
                System.out.println("Reader[" + String.valueOf(i) + "] reads from " + String.valueOf(toffset) + " with buffer size " + String.valueOf(tlen) + " and tries to read " + String.valueOf(numtoread) + " bytes");
            }
            try {
                istream.readFully(b, toffset, numtoread);
            }
            catch (EOFException ee) {
                System.err.println(ee);
                throw new IOException("Unexpected EOF");
            }
            catch (IOException e) {
                throw e;
            }
            value += numtoread;
        }
        ++this.seq_;
        return value;
    }

    protected int readMultiThreaded(byte[] b, int off, int length) throws IOException {
        int i;
        int value = 0;
        this.resetVariables();
        for (i = 0; i < this.readers_.length; ++i) {
            this.readers_[i].set(b, off, length);
        }
        if (PConfig.debug) {
            System.out.println("PInputStream is waking up all readers.");
        }
        if (PConfig.debug) {
            System.out.println("PInputStream is waiting for readers to finish.");
        }
        this.waitReaders();
        if (PConfig.debug) {
            System.out.println("PInputStream is finished reading\n");
        }
        boolean eof = true;
        for (i = 0; i < this.readers_.length; ++i) {
            eof &= this.readers_[i].isEOF();
        }
        if (eof) {
            return -1;
        }
        for (i = 0; i < this.status_.length; ++i) {
            if (!this.status_[i]) {
                throw new IOException("Internal input stream error");
            }
            value += this.readLens_[i];
        }
        ++this.seq_;
        return value;
    }

    private void resetVariables() {
        for (int i = 0; i < this.status_.length; ++i) {
            this.status_[i] = true;
            this.readLens_[i] = 0;
        }
        this.readCount_ = 0;
    }

    private synchronized void waitReaders() {
        while (this.readCount_ < this.inputs_.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void readerStatus(int pos, boolean stat, int len) {
        if (pos >= 0 && pos < this.status_.length) {
            this.status_[pos] = stat;
            this.readLens_[pos] = len;
            ++this.readCount_;
        }
        if (this.readCount_ == this.status_.length) {
            this.notify();
        }
    }

    public synchronized boolean finished() {
        return this.done_;
    }
}

