/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.tracer.client;

import de.fzj.unicore.uas.util.Pair;
import java.util.ArrayList;
import java.util.Calendar;
import org.chemomentum.tracer.client.AndMessageQuery;
import org.chemomentum.tracer.client.IMessageQuery;
import org.chemomentum.tracer.client.NotMessageQuery;
import org.chemomentum.tracer.client.OrMessageQuery;
import org.chemomentum.tracer.client.PatternMessageQuery;
import org.chemomentum.tracer.client.TimeMessageQuery;
import org.chemomentum.tracer.client.TraceQueryDescription;
import org.chemomentum.tracer.xmlbeans.Boundary;
import org.chemomentum.tracer.xmlbeans.ColumnNames;
import org.chemomentum.tracer.xmlbeans.JoinOfQueries;
import org.chemomentum.tracer.xmlbeans.KindOfQuery;
import org.chemomentum.tracer.xmlbeans.Operator;
import org.chemomentum.tracer.xmlbeans.ResponseFormatType;
import org.chemomentum.tracer.xmlbeans.TraceQueryDocument;

public class XMLToQueryConverter {
    public static TraceQueryDescription convert(TraceQueryDocument tqd) throws Exception {
        TraceQueryDescription result = new TraceQueryDescription();
        TraceQueryDocument.TraceQuery tq = tqd.getTraceQuery();
        KindOfQuery koq = tq.getQuery();
        IMessageQuery query = XMLToQueryConverter.convert(koq);
        result.setQuery(query);
        ResponseFormatType rft = tq.getResponseFormat();
        if (rft.isSetMessageFormat()) {
            Boundary[] bounds;
            ColumnNames.Enum[] cols = rft.getMessageFormat().getSelectedColumnsArray();
            ArrayList<String> attributes = new ArrayList<String>();
            ColumnNames.Enum[] enumArray = cols;
            int n = cols.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnNames.Enum col = enumArray[n2];
                attributes.add(col.toString());
                ++n2;
            }
            result.setAttributes(attributes);
            Boundary[] boundaryArray = bounds = rft.getMessageFormat().getLimitMessagesArray();
            int n3 = bounds.length;
            n = 0;
            while (n < n3) {
                Boundary bound = boundaryArray[n];
                String start = bound.getBegin();
                String end = bound.getEnd();
                result.addBoundary((Pair<String, String>)new Pair((Object)start, (Object)end));
                ++n;
            }
        } else if (rft.isSetPrintNumberOfMessages()) {
            result.setMode(1);
        }
        return result;
    }

    private static IMessageQuery convert(KindOfQuery koq) throws Exception {
        if (koq.isSetJoin()) {
            JoinOfQueries join = koq.getJoin();
            IMessageQuery left = XMLToQueryConverter.convert(join.getLeftOperand());
            IMessageQuery right = XMLToQueryConverter.convert(join.getRightOperand());
            Operator.Enum op = join.getJoinOperator();
            if (((Object)((Object)Operator.AND)).equals((Object)op)) {
                return new AndMessageQuery(left, right);
            }
            if (((Object)((Object)Operator.OR)).equals((Object)op)) {
                return new OrMessageQuery(left, right);
            }
            throw new Exception("Unrecognized XML query description: " + koq.toString());
        }
        if (koq.isSetPattern()) {
            String pattern = koq.getPattern().getPattern();
            String column = koq.getPattern().getColumn();
            return new PatternMessageQuery(column, pattern);
        }
        if (koq.isSetTime()) {
            Calendar begin = koq.getTime().getBegin();
            Calendar end = koq.getTime().getEnd();
            return new TimeMessageQuery(begin.getTimeInMillis(), end.getTimeInMillis());
        }
        if (koq.isSetNegation()) {
            IMessageQuery inner = XMLToQueryConverter.convert(koq.getNegation().getOperand());
            return new NotMessageQuery(inner);
        }
        throw new Exception("Unrecognized XML query description: " + koq.toString());
    }
}

