/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.tracer.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Properties;
import org.chemomentum.common.ws.ITrace;
import org.chemomentum.tracer.client.QueryToOldXMLConverter;
import org.chemomentum.tracer.client.QueryToXMLConverter;
import org.chemomentum.tracer.client.TraceQueryDescription;
import org.chemomentum.tracer.xmlbeans.FilterEntriesRequestDocument;
import org.chemomentum.tracer.xmlbeans.FilterEntriesResponseDocument;
import org.chemomentum.tracer.xmlbeans.SendTraceRequestDocument;
import org.chemomentum.tracer.xmlbeans.TraceDocument;
import org.chemomentum.tracer.xmlbeans.TraceQueryDocument;
import org.chemomentum.tracer.xmlbeans.TracerPropertiesDocument;
import org.codehaus.xfire.XFireRuntimeException;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TraceClient
extends BaseUASClient {
    public static final String SERVER_VERSION_6_2 = "1.2.0";
    public static final String SERVER_VERSION_6_3 = "1.3.0";
    private static final String TRACER_PROP = "tracer impl";
    private String serverVersion = null;
    private ITrace tracer = null;

    public TraceClient(EndpointReferenceType epr, IClientConfiguration sp) throws Exception {
        super(epr.getAddress().getStringValue(), epr, sp);
    }

    public TraceClient(ITrace tracer) throws Exception {
        super("", TraceClient.createFakeEPR(), TraceClient.createClientConfiguration(tracer));
        this.tracer = tracer;
    }

    private static EndpointReferenceType createFakeEPR() {
        EndpointReferenceType result = EndpointReferenceType.Factory.newInstance();
        result.addNewAddress().setStringValue("");
        return result;
    }

    private static IClientConfiguration createClientConfiguration(ITrace tracer) {
        ClientProperties result = new ClientProperties(new Properties());
        result.setExtraSecurityTokens(new HashMap());
        result.getExtraSecurityTokens().put(TRACER_PROP, tracer);
        return result;
    }

    public <T> T makeProxy(Class<T> iFace) throws Exception {
        if (this.tracer == null && this.getSecurityConfiguration() != null && this.getSecurityConfiguration().getExtraSecurityTokens() != null && this.getSecurityConfiguration().getExtraSecurityTokens().get(TRACER_PROP) instanceof ITrace) {
            this.tracer = (ITrace)this.getSecurityConfiguration().getExtraSecurityTokens().get(TRACER_PROP);
        }
        if (this.tracer != null) {
            if (iFace.isAssignableFrom(this.tracer.getClass())) {
                return (T)this.tracer;
            }
            throw new Exception("The provided " + ITrace.class.getSimpleName() + " implementation of type " + this.tracer.getClass().getName() + " does not implement the interface " + iFace.getName() + ".");
        }
        return (T)super.makeProxy(iFace);
    }

    public TraceDocument.Trace query(String field, String pattern) throws Exception {
        FilterEntriesRequestDocument ferd = FilterEntriesRequestDocument.Factory.newInstance();
        FilterEntriesRequestDocument.FilterEntriesRequest fer = ferd.addNewFilterEntriesRequest();
        fer.setField(field);
        fer.setPattern(pattern);
        FilterEntriesResponseDocument td = this.makeProxy(ITrace.class).filterEntries(ferd);
        if (td == null) {
            return null;
        }
        return td.getFilterEntriesResponse().getTrace();
    }

    public FilterEntriesResponseDocument query(TraceQueryDescription tpq) throws Exception {
        if (this.getServerVersion().compareTo(SERVER_VERSION_6_2) > 0) {
            TraceQueryDocument doc = QueryToXMLConverter.convert(tpq);
            return this.makeProxy(ITrace.class).query(doc);
        }
        FilterEntriesRequestDocument ferd = QueryToOldXMLConverter.convert(tpq);
        FilterEntriesResponseDocument result = this.makeProxy(ITrace.class).filterEntries(ferd);
        long numMessages = 0L;
        try {
            numMessages = result.getFilterEntriesResponse().getTrace().sizeOfEntryArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.getFilterEntriesResponse().setNumberOfAvailableMessages(new BigInteger("" + numMessages));
        return result;
    }

    public void trace(SendTraceRequestDocument doc) throws Exception {
        this.makeProxy(ITrace.class).trace(doc);
    }

    public String getServerVersion() throws Exception {
        if (this.serverVersion != null) {
            return this.serverVersion;
        }
        try {
            this.serverVersion = this.getResourcePropertiesDocument().getTracerProperties().getVersion();
        }
        catch (XFireRuntimeException e) {
            String msg;
            if (e.getCause() != null && e.getCause().getMessage() != null && (msg = e.getCause().getMessage()).toLowerCase().matches(".*action.*was not found for service.*")) {
                this.serverVersion = SERVER_VERSION_6_2;
                return this.serverVersion;
            }
            throw e;
        }
        return this.serverVersion;
    }

    public TracerPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TracerPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }
}

