/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util.jsdl;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.chemomentum.common.util.jsdl.Input;
import org.chemomentum.common.util.jsdl.Output;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;

public class JSDLUtils {
    private JobDefinitionDocument jsdl;
    private final QName POSIX_APP = POSIXApplicationDocument.type.getDocumentElementName();

    public JSDLUtils(JobDefinitionType jsdl) {
        this.jsdl = JobDefinitionDocument.Factory.newInstance();
        this.jsdl.setJobDefinition(jsdl);
    }

    public JSDLUtils(JobDefinitionDocument jsdl) {
        this.jsdl = jsdl;
    }

    public JobDefinitionDocument getJsdl() {
        return this.jsdl;
    }

    public void setJsdl(JobDefinitionDocument jsdl) {
        this.jsdl = jsdl;
    }

    public void setJsdl(JobDefinitionType jsdl) {
        this.jsdl = JobDefinitionDocument.Factory.newInstance();
        this.jsdl.setJobDefinition(jsdl);
    }

    public List<Input> getInputs() {
        ArrayList<Input> res = new ArrayList<Input>();
        try {
            DataStagingType[] dst;
            DataStagingType[] dataStagingTypeArray = dst = this.jsdl.getJobDefinition().getJobDescription().getDataStagingArray();
            int n = dst.length;
            int n2 = 0;
            while (n2 < n) {
                DataStagingType d = dataStagingTypeArray[n2];
                if (d.getSource() != null) {
                    Input i = new Input(d.getSource().getURI(), d.getFileName(), d);
                    res.add(i);
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return res;
    }

    public List<Output> getOutputs() {
        ArrayList<Output> res = new ArrayList<Output>();
        try {
            DataStagingType[] dst;
            DataStagingType[] dataStagingTypeArray = dst = this.jsdl.getJobDefinition().getJobDescription().getDataStagingArray();
            int n = dst.length;
            int n2 = 0;
            while (n2 < n) {
                DataStagingType d = dataStagingTypeArray[n2];
                if (d.getTarget() != null) {
                    Output o = new Output(d.getFileName(), d.getTarget().getURI(), d);
                    res.add(o);
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return res;
    }

    public int removeInputs(String scheme) {
        DataStagingType[] dst = this.jsdl.getJobDefinition().getJobDescription().getDataStagingArray();
        ArrayList<DataStagingType> res = new ArrayList<DataStagingType>();
        int c = 0;
        DataStagingType[] dataStagingTypeArray = dst;
        int n = dst.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                DataStagingType d;
                block3: {
                    d = dataStagingTypeArray[n2];
                    try {
                        if (d.getSource() == null || !d.getSource().getURI().toLowerCase().startsWith(scheme.toLowerCase())) break block3;
                        ++c;
                        break block4;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                res.add(d);
            }
            ++n2;
        }
        this.jsdl.getJobDefinition().getJobDescription().setDataStagingArray(res.toArray(new DataStagingType[res.size()]));
        return c;
    }

    public int removeOutputs(String scheme) {
        DataStagingType[] dst = this.jsdl.getJobDefinition().getJobDescription().getDataStagingArray();
        ArrayList<DataStagingType> res = new ArrayList<DataStagingType>();
        int c = 0;
        DataStagingType[] dataStagingTypeArray = dst;
        int n = dst.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                DataStagingType d;
                block3: {
                    d = dataStagingTypeArray[n2];
                    try {
                        if (d.getTarget() == null || !d.getTarget().getURI().toLowerCase().startsWith(scheme.toLowerCase())) break block3;
                        ++c;
                        break block4;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                res.add(d);
            }
            ++n2;
        }
        this.jsdl.getJobDefinition().getJobDescription().setDataStagingArray(res.toArray(new DataStagingType[res.size()]));
        return c;
    }

    public void setPOSIXApplication(POSIXApplicationDocument pApp) {
        Object cursor = null;
        try {
            this.removeXML(this.POSIX_APP);
            ApplicationDocument app = ApplicationDocument.Factory.newInstance();
            ApplicationType a = this.jsdl.getJobDefinition().getJobDescription().getApplication();
            if (a == null) {
                a = app.addNewApplication();
            } else {
                app.setApplication(a);
            }
            WSUtilities.append((XmlObject)pApp, (XmlObject)app);
            this.jsdl.getJobDefinition().getJobDescription().setApplication(app.getApplication());
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    public POSIXApplicationDocument getPOSIXApplicationCopy() {
        XmlCursor cursor = null;
        try {
            cursor = this.jsdl.getJobDefinition().getJobDescription().getApplication().newCursor();
            if (this.skipToElement(cursor, this.POSIX_APP)) {
                POSIXApplicationDocument pd;
                POSIXApplicationDocument pOSIXApplicationDocument = pd = POSIXApplicationDocument.Factory.parse((Reader)cursor.newReader());
                return pOSIXApplicationDocument;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return null;
    }

    private void removeXML(QName q) {
        XmlCursor cursor = null;
        try {
            cursor = this.jsdl.newCursor();
            if (this.skipToElement(cursor, q)) {
                cursor.removeXml();
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    private boolean skipToElement(XmlCursor cursor, QName name) {
        while (cursor.hasNextToken()) {
            XmlCursor.TokenType tt = cursor.toNextToken();
            if (!tt.isStart() || !name.equals(cursor.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnv(String s) {
        return s != null && s.startsWith("env://");
    }

    public static boolean isContext(String s) {
        return s != null && s.startsWith("context://");
    }

    public static boolean isLogicalFilename(String s) {
        return s != null && s.startsWith("c9m:");
    }

    public static boolean isFile(String s) {
        return s != null && !JSDLUtils.isContext(s) && !JSDLUtils.isEnv(s);
    }
}

