/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util;

import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import eu.unicore.security.util.client.IClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryCrawler {
    protected static Logger logger = Logger.getLogger((String)RegistryCrawler.class.getName());
    private String regUrl;
    private RegistryClient reg;

    public RegistryCrawler(EndpointReferenceType registry_epr, IClientProperties sp) {
        this.regUrl = registry_epr.getAddress().getStringValue();
        logger.debug((Object)("Trying to reach registry." + this.regUrl));
        try {
            this.reg = new RegistryClient(this.regUrl, registry_epr, (IClientConfiguration)sp);
        }
        catch (Exception e) {
            logger.log((Priority)Level.WARN, (Object)("Could not reach Registry at " + this.regUrl + "!"), (Throwable)e);
        }
    }

    public List<EndpointReferenceType> findServiceInstances(QName port) {
        ArrayList<EndpointReferenceType> instances = new ArrayList();
        try {
            logger.debug((Object)("Searching for instances of type: " + port.getLocalPart()));
            instances = this.reg.listServices(port);
        }
        catch (Exception e) {
            logger.log((Priority)Level.WARN, (Object)("Could not reach Registry at " + this.regUrl + "!"), (Throwable)e);
        }
        return instances;
    }
}

