/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util;

import java.net.URL;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Addressing {
    protected static Logger logger = Logger.getLogger((String)Addressing.class.getName());

    public static URL EPR2ServiceContainerURL(EndpointReferenceType epr) {
        if (epr == null) {
            return null;
        }
        try {
            URL tmp_url = new URL(epr.getAddress().getStringValue());
            logger.debug((Object)("tmp_url: " + tmp_url));
            String path = tmp_url.getPath();
            path = path.replaceFirst("[^/]*/*$", "");
            return new URL(String.valueOf(tmp_url.getProtocol()) + "://" + tmp_url.getAuthority() + path);
        }
        catch (Exception e) {
            logger.log((Priority)Level.WARN, (Object)"Discovered malformed EPR ", (Throwable)e);
            return null;
        }
    }

    public static URL EPR2ServiceURL(EndpointReferenceType epr) {
        try {
            URL tmp_url = new URL(epr.getAddress().getStringValue());
            logger.debug((Object)("tmp_url: " + tmp_url));
            String path = tmp_url.getPath();
            return new URL(String.valueOf(tmp_url.getProtocol()) + "://" + tmp_url.getAuthority() + path);
        }
        catch (Exception e) {
            logger.log((Priority)Level.WARN, (Object)"Discovered malformed EPR ", (Throwable)e);
            return null;
        }
    }

    public static String EPR2ResourceID(EndpointReferenceType epr) {
        try {
            URL tmp_url = new URL(epr.getAddress().getStringValue());
            return tmp_url.getQuery().replace("res=", "");
        }
        catch (Exception e) {
            System.out.println("Discovered malformed EPR ");
            e.printStackTrace();
            return null;
        }
    }

    public static EndpointReferenceType String2EPR(String address) {
        if (address == null) {
            return null;
        }
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(address);
        return epr;
    }
}

