/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.impl.gris;

import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.chemomentum.gris.xmlbeans.AttributeType;
import org.chemomentum.gris.xmlbeans.ResourceType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ResourceObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = Logger.getLogger((String)ResourceObject.class.getName());
    protected ConcurrentHashMap<QName, AttributeType> attributes;
    protected EndpointReferenceType epr;
    protected IClientConfiguration securityProperties;
    protected String type;
    protected EndpointReferenceType submissionEpr;

    public ResourceObject(ResourceType xml) {
        this.parseResource(xml);
    }

    public AttributeType getAttribute(QName name) {
        return this.getAttributes().get(name);
    }

    public Map<QName, AttributeType> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap();
        }
        return this.attributes;
    }

    protected AttributeType[] getAttributes(QName[] relevantAttNames) {
        ArrayList<AttributeType> relevantAtts = new ArrayList<AttributeType>(relevantAttNames.length);
        int i = 0;
        while (i < relevantAttNames.length) {
            AttributeType att = this.getAttribute(relevantAttNames[i]);
            if (att != null) {
                relevantAtts.add(att);
            }
            ++i;
        }
        return relevantAtts.toArray(new AttributeType[0]);
    }

    public EndpointReferenceType getEpr() {
        return this.epr;
    }

    public IClientConfiguration getSecurityProperties() {
        return this.securityProperties;
    }

    public String getType() {
        return this.type;
    }

    public EndpointReferenceType getSubmissionEpr() {
        return this.submissionEpr;
    }

    public int hashCode() {
        return this.getEpr().getAddress().getStringValue().hashCode();
    }

    public void parseResource(ResourceType xml) {
        this.setType(xml.getStyle());
        this.setEpr(xml.getEpr());
        this.setAttributes(xml.getAttributeArray());
    }

    public void setAttribute(AttributeType att) {
        this.getAttributes().put(att.getKey(), att);
    }

    public void setAttributes(AttributeType[] atts) {
        if (atts == null) {
            this.attributes = null;
            return;
        }
        int i = 0;
        while (i < atts.length) {
            this.setAttribute(atts[i]);
            ++i;
        }
    }

    public void setEpr(EndpointReferenceType epr) {
        this.epr = epr;
    }

    public void setSecurityProperties(IClientConfiguration securityProperties) {
        this.securityProperties = securityProperties;
    }

    public void setType(String style) {
        this.type = style;
    }

    public void setSubmissionEpr(EndpointReferenceType submissionEpr) {
        this.submissionEpr = submissionEpr;
    }

    public String toString() {
        return "epr: " + this.epr.getAddress().getStringValue();
    }

    public ResourceType toXml() {
        ResourceType res = ResourceType.Factory.newInstance();
        res.setStyle(this.getType());
        res.setEpr(this.getEpr());
        res.setAttributeArray(this.getAttributes().values().toArray(new AttributeType[0]));
        return res;
    }

    public ResourceType toXml(QName[] relevantAttNames) {
        ResourceType res = ResourceType.Factory.newInstance();
        res.setStyle(this.getType());
        res.setEpr(this.getEpr());
        if (relevantAttNames == null || relevantAttNames.length == 0) {
            return res;
        }
        res.setAttributeArray(this.getAttributes(relevantAttNames));
        return res;
    }
}

