/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.impl.gris;

import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.chemomentum.common.impl.gris.ResourceObject;
import org.chemomentum.common.ws.IGridResourceInfoDownload;
import org.chemomentum.gris.xmlbeans.AvailableAttributeType;
import org.chemomentum.gris.xmlbeans.GetAllResourcesRequestDocument;
import org.chemomentum.gris.xmlbeans.GetAllResourcesResponseDocument;
import org.chemomentum.gris.xmlbeans.GetAvailableAttributesRequestDocument;
import org.chemomentum.gris.xmlbeans.GetAvailableAttributesResponseDocument;
import org.chemomentum.gris.xmlbeans.GetResourcesRequestDocument;
import org.chemomentum.gris.xmlbeans.GetResourcesResponseDocument;
import org.chemomentum.gris.xmlbeans.ResourceType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class GridResourceInfoDownloadClient {
    protected String grisUrl;
    protected EndpointReferenceType grisEpr;
    IClientConfiguration secProperties;
    private static final Logger logger = Logger.getLogger((String)GridResourceInfoDownloadClient.class.getName());
    protected IGridResourceInfoDownload gris;

    public GridResourceInfoDownloadClient(IGridResourceInfoDownload gris) {
        this.gris = gris;
    }

    public GridResourceInfoDownloadClient(String url, EndpointReferenceType epr, IClientConfiguration sec) {
        this.grisUrl = url;
        this.grisEpr = epr;
        this.secProperties = sec;
    }

    public ResourceObject[] getAllComputationalResources(QName[] requiredAttributes) {
        String[] styles = new String[]{"*"};
        return this.getAllResources(styles, requiredAttributes);
    }

    public ResourceObject[] getComputationalResources(EndpointReferenceType[] candidates, QName[] requiredAttributes) {
        return this.getResources(candidates, requiredAttributes);
    }

    public ResourceObject[] getAllResources() {
        return this.getAllResources(null, null);
    }

    public ResourceObject[] getAllResources(String[] styles, QName[] requestedAttributes) {
        GetAllResourcesRequestDocument request = GetAllResourcesRequestDocument.Factory.newInstance();
        request.addNewGetAllResourcesRequest();
        if (styles != null) {
            request.getGetAllResourcesRequest().setRequestedStyleArray(styles);
        }
        if (requestedAttributes != null) {
            request.getGetAllResourcesRequest().setRequestedAttributeArray(requestedAttributes);
        }
        GetAllResourcesResponseDocument response = this.getGRIS().getAllResources(request);
        ResourceType[] allRes = response.getGetAllResourcesResponse().getResourceArray();
        ResourceObject[] allResObjects = new ResourceObject[allRes.length];
        int i = 0;
        while (i < allRes.length) {
            allResObjects[i] = new ResourceObject(allRes[i]);
            ++i;
        }
        return allResObjects;
    }

    public ResourceObject[] getResources(EndpointReferenceType[] resEprs, QName[] requestedAttributes) {
        GetResourcesRequestDocument request = GetResourcesRequestDocument.Factory.newInstance();
        request.addNewGetResourcesRequest().setEprArray(resEprs);
        if (requestedAttributes != null) {
            request.getGetResourcesRequest().setRequestedAttributeArray(requestedAttributes);
        }
        GetResourcesResponseDocument response = this.getGRIS().getResources(request);
        ResourceType[] allRes = response.getGetResourcesResponse().getResourceArray();
        ResourceObject[] allResObjects = new ResourceObject[allRes.length];
        int i = 0;
        while (i < allRes.length) {
            allResObjects[i] = new ResourceObject(allRes[i]);
            ++i;
        }
        return allResObjects;
    }

    public Map<QName, AvailableAttributeType> getAvailableAttributes() {
        GetAvailableAttributesRequestDocument request = GetAvailableAttributesRequestDocument.Factory.newInstance();
        request.addNewGetAvailableAttributesRequest();
        GetAvailableAttributesResponseDocument response = this.getGRIS().getAvailableAttributes(request);
        ConcurrentHashMap<QName, AvailableAttributeType> result = new ConcurrentHashMap<QName, AvailableAttributeType>();
        AvailableAttributeType[] atts = response.getGetAvailableAttributesResponse().getAvailableAttributeArray();
        if (atts != null) {
            int i = 0;
            while (i < atts.length) {
                result.put(atts[i].getKey(), atts[i]);
                ++i;
            }
        }
        return result;
    }

    protected IGridResourceInfoDownload getGRIS() {
        if (this.gris == null) {
            if (this.grisUrl == null || this.grisEpr == null) {
                logger.log((Priority)Level.WARN, (Object)"Could not invoke GRIS Service! No address for GRIS Service available!");
            } else {
                try {
                    return (IGridResourceInfoDownload)new UnicoreXFireClientFactory(this.secProperties).createPlainWSProxy(IGridResourceInfoDownload.class, this.grisUrl);
                }
                catch (Exception e) {
                    logger.log((Priority)Level.WARN, (Object)"Could not invoke GRIS Service! ", (Throwable)e);
                }
            }
        }
        return this.gris;
    }
}

