/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.util.AttributeFilter;

public class VOAttributeFilter
implements AttributeFilter {
    public static final VOAttributeFilter EMPTY_FILTER = new VOAttributeFilter(".*", ""){

        @Override
        public boolean allowsEverything() {
            return true;
        }
    };
    private List<AttributePattern> includedPatterns;
    private List<AttributePattern> excludedPatterns;

    public static VOAttributeFilter build(String included, String excluded) {
        if (included == null && excluded == null) {
            return EMPTY_FILTER;
        }
        return new VOAttributeFilter(included, excluded);
    }

    public VOAttributeFilter(String included, String excluded) {
        if (included == null) {
            included = ".*";
        }
        if (excluded == null) {
            excluded = "";
        }
        String[] i = included.split(";");
        String[] e = excluded.split(";");
        this.includedPatterns = new ArrayList<AttributePattern>(i.length);
        this.excludedPatterns = new ArrayList<AttributePattern>(e.length);
        for (String p : i) {
            if (p.length() <= 0) continue;
            this.includedPatterns.add(new AttributePattern(p));
        }
        for (String p : e) {
            if (p.length() <= 0) continue;
            this.excludedPatterns.add(new AttributePattern(p));
        }
    }

    public List<Attribute> filter(List<Attribute> attributes) {
        ArrayList<AttributeStatus> statuses = new ArrayList<AttributeStatus>(attributes.size());
        for (Attribute attr : attributes) {
            statuses.add(new AttributeStatus(attr));
        }
        for (AttributePattern eap : this.excludedPatterns) {
            for (AttributeStatus s : statuses) {
                eap.excludeIfMatches(s);
            }
        }
        for (AttributePattern iap : this.includedPatterns) {
            for (AttributeStatus s : statuses) {
                iap.includeIfMatches(s);
            }
        }
        for (AttributeStatus s : statuses) {
            s.process();
        }
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (AttributeStatus s : statuses) {
            if (s.attribute == null) continue;
            result.add(s.attribute);
        }
        return result;
    }

    public String toString() {
        return "Included: " + this.includedPatterns.toString() + ", Excluded: " + this.excludedPatterns.toString();
    }

    public boolean allowsEverything() {
        return false;
    }

    private static class AttributeStatus {
        Attribute attribute;
        boolean excluded = false;
        boolean included = false;
        boolean thereAreNoValuelessIncludePatterns = true;
        List<Pattern> excludeValuePatterns;
        List<Pattern> includeValuePatterns;

        AttributeStatus(Attribute at) {
            this.attribute = at;
            this.excludeValuePatterns = new ArrayList<Pattern>();
            this.includeValuePatterns = new ArrayList<Pattern>();
        }

        void process() {
            if (this.excluded && this.includeValuePatterns.isEmpty() || !this.included && !this.thereAreNoValuelessIncludePatterns) {
                this.attribute = null;
                return;
            }
            ArrayList<String> newValues = new ArrayList<String>();
            for (String v : this.attribute.getValues()) {
                boolean ok = true;
                for (Pattern evp : this.excludeValuePatterns) {
                    if (!evp.matcher(v).matches()) continue;
                    ok = false;
                    break;
                }
                if (ok && !this.includeValuePatterns.isEmpty()) {
                    ok = false;
                    for (Pattern ivp : this.includeValuePatterns) {
                        if (!ivp.matcher(v).matches()) continue;
                        ok = true;
                        break;
                    }
                }
                if (!ok) continue;
                newValues.add(v);
            }
            if (newValues.isEmpty()) {
                this.attribute = null;
            } else if (newValues.size() != this.attribute.getValues().size()) {
                this.attribute = new Attribute(this.attribute.getName(), newValues, this.attribute.getScope());
            }
        }
    }

    private static class AttributePattern {
        Pattern namePattern;
        Pattern valuePattern;

        AttributePattern(String regex) {
            if (regex.contains("=")) {
                String[] parts = regex.split("=", 2);
                this.namePattern = Pattern.compile("^" + parts[0].trim() + "$");
                this.valuePattern = Pattern.compile("^" + parts[1].trim() + "$");
            } else {
                this.namePattern = Pattern.compile("^" + regex.trim() + "$");
                this.valuePattern = null;
            }
        }

        void excludeIfMatches(AttributeStatus status) {
            if (!this.namePattern.matcher(status.attribute.getName()).matches()) {
                return;
            }
            if (this.valuePattern == null) {
                status.excluded = true;
            } else {
                status.excludeValuePatterns.add(this.valuePattern);
            }
        }

        void includeIfMatches(AttributeStatus status) {
            if (this.valuePattern == null) {
                status.thereAreNoValuelessIncludePatterns = false;
            }
            if (!this.namePattern.matcher(status.attribute.getName()).matches()) {
                return;
            }
            status.included = true;
            if (this.valuePattern != null) {
                status.includeValuePatterns.add(this.valuePattern);
            }
        }

        public String toString() {
            if (this.valuePattern != null) {
                return this.namePattern.pattern() + " = " + this.valuePattern.pattern();
            }
            return this.namePattern.pattern() + " = <anything>";
        }
    }
}

