/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnitParser {
    private static Pattern valueWithUnitsPattern = Pattern.compile("\\s*(\\d*[\\.\\,]?\\d*)\\s*(\\w*)\\s*");
    private final String[][] units;
    private final int[] conversionFactors;
    private final NumberFormat outputFormat;
    private final int decimalDigits;
    static String[][] capacityUnits = new String[][]{{"", "bytes"}, {"K", "kilobytes", "kb"}, {"M", "megabytes", "mb"}, {"G", "gigabytes", "gb"}, {"T", "terabytes", "tb"}};
    static int[] capacityFactors = new int[]{1024, 1024, 1024, 1024};
    static String[][] timeUnits = new String[][]{{"sec", "seconds"}, {"min", "minutes"}, {"h", "hours"}, {"d", "days"}};
    static int[] timeFactors = new int[]{60, 60, 24};
    private static DateFormat hhmmDate;
    private static DateFormat iso8601;
    private static DateFormat simple;

    public UnitParser(String[][] units, int[] conversionFactors, int decimalDigits) {
        this.units = units;
        this.conversionFactors = conversionFactors;
        this.outputFormat = NumberFormat.getNumberInstance();
        this.outputFormat.setMaximumFractionDigits(decimalDigits);
        this.outputFormat.setMinimumFractionDigits(decimalDigits);
        this.decimalDigits = decimalDigits;
    }

    public UnitParser(String[][] units, int[] conversionFactors) {
        this(units, conversionFactors, 0);
    }

    public String getStringValue(String valueWithUnits) {
        return this.outputFormat.format(this.getDoubleValue(valueWithUnits));
    }

    public double getDoubleValue(String valueWithUnits) {
        String u = this.getUnits(valueWithUnits);
        int conversion = 1;
        if (u != null) {
            conversion = this.getConversionFactor(u);
        }
        return Double.parseDouble(this.getNumber(valueWithUnits)) * (double)conversion;
    }

    public String getHumanReadable(double d) {
        int factor = 1;
        String unit = "";
        double converted = d;
        for (int c = 0; c < this.conversionFactors.length; ++c) {
            factor *= this.conversionFactors[c];
            if (c < this.conversionFactors.length && converted < (double)this.conversionFactors[c]) break;
            unit = this.units[c + 1][0];
            converted = d / (double)factor;
        }
        if ("".equals(unit)) {
            this.outputFormat.setMinimumFractionDigits(0);
        }
        String res = this.outputFormat.format(converted) + unit;
        this.outputFormat.setMinimumFractionDigits(this.decimalDigits);
        return res;
    }

    public void setMinimumDigits(int digits) {
        this.outputFormat.setMinimumFractionDigits(digits);
    }

    int getConversionFactor(String unit) {
        int i = 0;
        boolean found = false;
        String[][] arr$ = this.units;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            String[] u;
            for (String u1 : u = arr$[i$]) {
                if (!u1.startsWith(unit)) continue;
                found = true;
                break block0;
            }
            ++i;
        }
        if (found) {
            int result = 1;
            for (int j = 0; j < i; ++j) {
                result *= this.conversionFactors[j];
            }
            return result;
        }
        throw new IllegalArgumentException("No conversion for unit '" + unit + "'");
    }

    String getNumber(String valueWithUnits) {
        Matcher m = valueWithUnitsPattern.matcher(valueWithUnits);
        if (m.matches()) {
            return m.group(1);
        }
        throw new NumberFormatException("not a parsable value: " + valueWithUnits);
    }

    String getUnits(String valueWithUnits) {
        Matcher m = valueWithUnitsPattern.matcher(valueWithUnits);
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }

    public static UnitParser getCapacitiesParser(int decimalDigits) {
        return new UnitParser(capacityUnits, capacityFactors, decimalDigits);
    }

    public static UnitParser getTimeParser(int decimalDigits) {
        return new UnitParser(timeUnits, timeFactors, decimalDigits);
    }

    public static synchronized Date extractDateTime(String spec) {
        Date result = null;
        try {
            Date d1 = UnitParser.getHHMMDate().parse(spec);
            Calendar c = Calendar.getInstance();
            c.set(11, d1.getHours());
            c.set(12, d1.getMinutes());
            System.out.println(c.getTime());
            if (c.compareTo(Calendar.getInstance()) < 0) {
                c.add(5, 1);
            }
            result = c.getTime();
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = UnitParser.getSimpleDateFormat().parse(spec);
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = UnitParser.getISO8601().parse(spec);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Specified date string '" + spec + "'could not be parsed!");
    }

    public static String convertDateToISO8601(String dateSpec) {
        return UnitParser.getISO8601().format(UnitParser.extractDateTime(dateSpec));
    }

    public static DateFormat getHHMMDate() {
        if (hhmmDate == null) {
            hhmmDate = new SimpleDateFormat("HH:mm");
        }
        return hhmmDate;
    }

    public static DateFormat getISO8601() {
        if (iso8601 == null) {
            iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
        return iso8601;
    }

    public static DateFormat getSimpleDateFormat() {
        if (simple == null) {
            simple = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
        return simple;
    }
}

