/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.util.Filter;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class PropertyFilter
implements Filter {
    private String modifier;
    private String value;
    private String property;
    private MessageWriter msg;
    private static final String MOD_EQUAL = "equals";
    private static final String MOD_EQUAL_SHORT = "eq";
    private static final String MOD_NOTEQUAL = "notequals";
    private static final String MOD_NOTEQUAL_SHORT = "neq";
    private static final String MOD_GT = "greaterthan";
    private static final String MOD_GT_SHORT = "gt";
    private static final String MOD_LT = "lessthan";
    private static final String MOD_LT_SHORT = "lt";
    private static final String MOD_CONTAINS = "contains";
    private static final String MOD_CONTAINS_SHORT = "c";
    private static final String MOD_NOTCONTAINS = "notcontains";
    private static final String MOD_NOTCONTAINS_SHORT = "nc";

    private PropertyFilter(String property, String modifier, String value, MessageWriter msg) {
        this.modifier = modifier;
        this.property = property;
        this.value = value;
        this.msg = msg;
    }

    @Override
    public boolean filterMatches(BaseWSRFClient wsrf) {
        try {
            String wsrfProp = wsrf.getResourcePropertyDocument();
            XmlCursor c = XmlObject.Factory.parse((String)wsrfProp).newCursor();
            while (c.toNextToken().intValue() != XmlCursor.TokenType.START.intValue() || !this.property.equalsIgnoreCase(c.getName().getLocalPart())) {
            }
            while (c.toNextToken().intValue() != XmlCursor.TokenType.TEXT.intValue()) {
            }
            String propValue = c.getChars();
            c.dispose();
            this.msg.verbose("Property value: " + propValue);
            return this.compare(this.value, propValue);
        }
        catch (Exception e) {
            this.msg.error("Can't find property <" + this.property + ">", e);
            return false;
        }
    }

    protected boolean compare(String expected, String actual) {
        if (this.modifier.equalsIgnoreCase(MOD_EQUAL) || this.modifier.equalsIgnoreCase(MOD_EQUAL_SHORT)) {
            return expected.equalsIgnoreCase(actual);
        }
        if (this.modifier.equalsIgnoreCase(MOD_NOTEQUAL)) {
            return !expected.equalsIgnoreCase(actual);
        }
        if (this.modifier.equalsIgnoreCase(MOD_CONTAINS) || this.modifier.equalsIgnoreCase(MOD_CONTAINS_SHORT)) {
            return actual.contains(expected);
        }
        if (this.modifier.equalsIgnoreCase(MOD_NOTCONTAINS) || this.modifier.equalsIgnoreCase(MOD_NOTCONTAINS_SHORT)) {
            return !actual.contains(expected);
        }
        if (this.modifier.equalsIgnoreCase(MOD_LT) || this.modifier.equalsIgnoreCase(MOD_LT_SHORT)) {
            return actual.compareTo(expected) < 0;
        }
        if (this.modifier.equalsIgnoreCase(MOD_GT) || this.modifier.equalsIgnoreCase(MOD_GT_SHORT)) {
            return actual.compareTo(expected) > 0;
        }
        this.msg.verbose("Can't compare!");
        return false;
    }

    protected boolean compareNumbers(Long expected, Long actual) {
        if (this.modifier.equalsIgnoreCase(MOD_LT)) {
            return actual < expected;
        }
        if (this.modifier.equalsIgnoreCase(MOD_GT)) {
            return actual > expected;
        }
        return false;
    }

    public static final class Factory {
        private static final String[] modifiers = new String[]{"equals", "eq", "notequals", "neq", "contains", "notcontains", "c", "nc", "greaterthan", "gt", "lessthan", "lt"};

        public static Filter create(MessageWriter msg, String ... args) {
            if (args != null && args.length == 3) {
                String propName = args[0];
                String mod = args[1];
                String val = args[2];
                msg.verbose("Filtering on property " + propName);
                if (Factory.acceptModifier(mod)) {
                    return new PropertyFilter(propName, mod, val, msg);
                }
            }
            msg.verbose("Could not create filter.");
            return null;
        }

        private static boolean acceptModifier(String modifier) {
            for (String s : modifiers) {
                if (!s.equalsIgnoreCase(modifier)) continue;
                return true;
            }
            return false;
        }
    }
}

