/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.util.UnitParser;
import jline.ConsoleReader;
import jline.Terminal;

public class ProgressBar
implements ProgressListener<Long> {
    private Terminal terminal = null;
    private ConsoleReader reader = null;
    private MessageWriter msg = null;
    private long size = -1L;
    private long have = 0L;
    private long startedAt = 0L;
    private final UnitParser rateParser = UnitParser.getCapacitiesParser(1);
    private String sizeDisplay;
    private double rate = 0.0;
    private final String identifier;
    private final char[] x = new char[]{'|', '/', '-', '\\'};
    private int index = 0;
    private int width = 0;

    public ProgressBar(MessageWriter msg) {
        this("", -1L, msg);
    }

    public ProgressBar(String identifier, long size, MessageWriter msg) {
        this.identifier = identifier;
        this.msg = msg;
        this.startedAt = System.currentTimeMillis();
        try {
            this.terminal = Terminal.setupTerminal();
            this.reader = new ConsoleReader();
            this.terminal.beforeReadLine(this.reader, "", Character.valueOf('\u0000'));
        }
        catch (Exception e) {
            msg.error("Could not setup jline console output: " + e, null);
            this.terminal = null;
        }
        this.setSize(size);
    }

    public void setSize(long size) {
        this.size = size;
        this.sizeDisplay = this.rateParser.getHumanReadable(size);
    }

    public void updateTotal(long total) {
        if (this.terminal == null || total < 0L) {
            return;
        }
        this.updateRate();
        this.have = total;
        this.output();
    }

    public void update(long amount) {
        if (this.terminal == null || amount <= 0L) {
            return;
        }
        this.have += amount;
        this.updateRate();
        this.output();
    }

    protected void updateRate() {
        this.rate = 1000.0 * (double)this.have / (double)(System.currentTimeMillis() - this.startedAt);
    }

    protected void output() {
        int w;
        int max;
        StringBuilder sb = new StringBuilder();
        if (this.size > 0L) {
            long progress = this.have * 100L / this.size;
            sb.append(String.format("%3d%%  %s ", progress, this.sizeDisplay));
        } else {
            sb.append(this.x[this.index]);
            ++this.index;
            if (this.index == this.x.length) {
                this.index = 0;
            }
        }
        if (this.rate > 0.0) {
            sb.append(String.format("%sB/s", this.rateParser.getHumanReadable(this.rate)));
        }
        if ((max = (w = this.getTerminalWidth()) - sb.length() - 5) > 0) {
            sb.insert(0, String.format("%-" + max + "s ", this.identifier));
        }
        try {
            this.reader.getCursorBuffer().clearBuffer();
            this.reader.getCursorBuffer().write(sb.toString());
            this.reader.setCursorPosition(w);
            this.reader.redrawLine();
            this.reader.flushConsole();
        }
        catch (Exception e) {
            this.msg.error("Could not output to jline console: " + e, null);
            this.terminal = null;
        }
    }

    private int getTerminalWidth() {
        if (this.width == 0) {
            this.width = this.terminal.getTerminalWidth();
        }
        return this.width;
    }

    public void notifyProgress(Long amount) {
        if (amount != null) {
            this.update(amount);
        }
    }

    public boolean isCancelled() {
        return false;
    }

    public void finish() {
        if (this.size > 0L) {
            this.have = this.size;
        } else {
            this.setSize(this.have);
        }
        this.output();
        System.out.println();
    }
}

