/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.Resources;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class MultiRegistryQuery
implements IRegistryQuery {
    private final List<IRegistryQuery> clients = new ArrayList<IRegistryQuery>();
    private boolean filterDuplicates = true;
    private String connectionStatus = null;
    private final MessageWriter msg;
    private static long maxTimeOffset = 600000L;

    public MultiRegistryQuery(MessageWriter msg) {
        this.msg = msg;
    }

    public void addRegistry(IRegistryQuery registry) {
        this.clients.add(registry);
    }

    public List<EndpointReferenceType> listAccessibleServices(QName porttype) throws Exception {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (IRegistryQuery c : this.clients) {
            if (!c.checkConnection()) continue;
            List res = c.listAccessibleServices(porttype);
            if (this.filterDuplicates) {
                this.addIfNotExist(result, res);
                continue;
            }
            result.addAll(res);
        }
        return result;
    }

    public List<EndpointReferenceType> listServices(QName porttype, IRegistryQuery.ServiceListFilter acceptFilter) throws Exception {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (IRegistryQuery c : this.clients) {
            if (!c.checkConnection()) continue;
            List res = c.listServices(porttype, acceptFilter);
            if (this.filterDuplicates) {
                this.addIfNotExist(result, res);
                continue;
            }
            result.addAll(res);
        }
        return result;
    }

    public List<EndpointReferenceType> listServices(QName porttype) throws Exception {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (IRegistryQuery c : this.clients) {
            if (!c.checkConnection()) continue;
            List res = c.listServices(porttype);
            if (this.filterDuplicates) {
                this.addIfNotExist(result, res);
                continue;
            }
            result.addAll(res);
        }
        return result;
    }

    public List<EntryType> listEntries() {
        ArrayList<EntryType> result = new ArrayList<EntryType>();
        for (IRegistryQuery c : this.clients) {
            try {
                result.addAll(c.listEntries());
            }
            catch (Exception ex) {
                this.msg.verbose("Registry at " + this.getAddress(c) + " is not available: " + ex.getMessage());
            }
        }
        return result;
    }

    public String getConnectionStatus() {
        this.checkConnection();
        return this.connectionStatus;
    }

    private void addIfNotExist(List<EndpointReferenceType> target, List<EndpointReferenceType> source) {
        HashSet<String> addresses = new HashSet<String>();
        for (EndpointReferenceType epr : target) {
            addresses.add(epr.getAddress().getStringValue());
        }
        for (EndpointReferenceType e : source) {
            String address = e.getAddress().getStringValue();
            if (addresses.contains(address)) continue;
            addresses.add(address);
            target.add(e);
        }
    }

    public boolean isFilterDuplicates() {
        return this.filterDuplicates;
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.filterDuplicates = filterDuplicates;
    }

    private Boolean compute(Callable<Boolean> task, int timeout) {
        try {
            Future<Boolean> f = Resources.getExecutorService().submit(task);
            return f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
    }

    public boolean checkConnection() {
        return this.checkConnection(2000);
    }

    public boolean checkConnection(int timeout) {
        StringBuffer status = new StringBuffer();
        boolean result = false;
        for (final IRegistryQuery c : this.clients) {
            boolean currentOK;
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean ok = c.checkConnection();
                    if (ok && c instanceof BaseWSRFClient) {
                        try {
                            BaseWSRFClient ws = (BaseWSRFClient)c;
                            Calendar serverTime = ws.getCurrentTime();
                            MultiRegistryQuery.this.checkServerTime(serverTime, ws.getUrl());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return ok;
                }
            };
            Boolean res = this.compute(task, timeout);
            boolean bl = currentOK = res != null ? res : false;
            if (!currentOK) {
                status.append("[NOT AVAILABLE: ").append(this.getAddress(c));
                status.append("] ");
            }
            result = result || currentOK;
        }
        this.connectionStatus = result ? "OK" : status.toString();
        return result;
    }

    String getAddress(IRegistryQuery c) {
        if (c instanceof RegistryClient) {
            return ((RegistryClient)c).getUrl();
        }
        return c.getClass().getName();
    }

    boolean checkServerTime(Calendar serverTime, String serverID) {
        long millis = serverTime.getTimeInMillis() - System.currentTimeMillis();
        if (millis > maxTimeOffset) {
            this.msg.message("WARNING: local time and server time differ by more than 10 minutes for " + serverID);
            this.msg.message("This may lead to errors later!");
            return false;
        }
        return true;
    }
}

