/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtil {
    private JSONUtil() {
    }

    public static String getString(JSONObject obj, String key, String defaultValue) {
        try {
            return obj.getString(key);
        }
        catch (JSONException je) {
            return defaultValue;
        }
    }

    public static String getString(JSONObject obj, String key) {
        return JSONUtil.getString(obj, key, null);
    }

    public static String makeParseErrorMessage(String json, JSONException ex) {
        String line = "unknown";
        String[] parts = ex.getMessage().split("at character ");
        if (parts.length > 1) {
            try {
                int pos = Integer.parseInt(parts[1]);
                line = String.valueOf(JSONUtil.getLineNumber(json, pos));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return "Error parsing (at line " + line + ") " + ex.getMessage();
    }

    private static int getLineNumber(String s, int pos) throws IOException {
        int c;
        int l = 1;
        StringReader r = new StringReader(s.replace("\r\n", "\n").replace("\r", "\n"));
        while ((c = r.read()) > -1) {
            if (10 != c) continue;
            ++l;
        }
        return l;
    }

    public static Map<String, String> asMap(JSONObject o) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator i = o.keys();
        while (i.hasNext()) {
            String s = (String)i.next();
            try {
                result.put(s, o.getString(s));
            }
            catch (JSONException ex) {}
        }
        return result;
    }

    public static JSONObject asJSON(Map<String, String> map) {
        JSONObject o = new JSONObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                o.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {}
        }
        return o;
    }
}

