/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.UFTPFileTransferClient;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.util.FileTransferBase;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.ucc.util.ProgressBar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.unigrids.services.atomic.types.ProtocolType;

public class FileUploader
extends FileTransferBase {
    public FileUploader(String from, String to, Mode mode) throws FileNotFoundException {
        this(from, to, mode, true);
    }

    public FileUploader(String from, String to, Mode mode, boolean failOnError) throws FileNotFoundException {
        this.to = to;
        this.from = from;
        this.mode = mode;
        this.failOnError = failOnError;
        this.checkOK();
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    public void perform(StorageClient sms, MessageWriter msg) throws Exception {
        File fileSpec = new File(this.from);
        boolean hasWildCards = false;
        boolean isDirectory = fileSpec.isDirectory();
        File[] fileset = null;
        if (!isDirectory) {
            hasWildCards = this.hasWildCards(fileSpec);
        }
        this.chosenProtocol = sms.findSupportedProtocol(this.preferredProtocols.toArray(new ProtocolType.Enum[this.preferredProtocols.size()]));
        Map<String, String> extraParameters = this.makeExtraParameters(this.chosenProtocol, msg);
        if (!hasWildCards && !isDirectory) {
            this.uploadFile(fileSpec, this.to, sms, this.chosenProtocol, extraParameters, msg);
            return;
        }
        fileset = hasWildCards ? this.resolveWildCards(fileSpec) : fileSpec.listFiles();
        if (!this.isValidDirectory(this.to, sms)) {
            throw new IOException("The specified remote target '" + this.to + "' is not a directory");
        }
        if (this.to == null) {
            this.to = "/";
        }
        String target = isDirectory ? this.to + "/" + fileSpec.getName() : this.to;
        sms.createDirectory(target);
        this.uploadFiles(fileset, target, sms, this.chosenProtocol, extraParameters, msg);
    }

    private void uploadFiles(File[] files, String remoteDirectory, StorageClient sms, ProtocolType.Enum protocol, Map<String, String> extraParameters, MessageWriter msg) throws Exception {
        for (File localFile : files) {
            String target = remoteDirectory + "/" + localFile.getName();
            if (localFile.isDirectory()) {
                if (!this.recurse) {
                    msg.verbose("Skipping directory " + localFile.getAbsolutePath());
                    continue;
                }
                File[] fileset = localFile.listFiles();
                sms.createDirectory(target);
                this.uploadFiles(fileset, target, sms, protocol, extraParameters, msg);
                continue;
            }
            this.uploadFile(localFile, target, sms, protocol, extraParameters, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(File localFile, String remotePath, StorageClient sms, ProtocolType.Enum protocol, Map<String, String> extraParameters, MessageWriter msg) throws Exception {
        long startTime = System.currentTimeMillis();
        FileInputStream is = null;
        FileTransferClient ftc = null;
        try {
            if (remotePath == null) {
                remotePath = "/" + localFile.getName();
            } else if (remotePath.endsWith("/")) {
                remotePath = remotePath + localFile.getName();
            }
            msg.verbose("Uploading local file '" + localFile.getAbsolutePath() + "' -> '" + sms.getUrl() + "#" + remotePath + "'");
            is = new FileInputStream(localFile.getAbsolutePath());
            boolean append = Mode.append.equals((Object)this.mode);
            ftc = sms.getImport(remotePath, append, extraParameters, new ProtocolType.Enum[]{protocol});
            this.configure(ftc, extraParameters);
            if (append) {
                ftc.setAppend(true);
            }
            String url = ftc.getUrl();
            msg.verbose("File transfer URL : " + url);
            ProgressBar p = null;
            if (ftc instanceof FiletransferOptions.IMonitorable) {
                long size = localFile.length();
                if (this.isRange()) {
                    size = this.getRangeSize();
                }
                p = new ProgressBar(localFile.getName(), size, msg);
                ((FiletransferOptions.IMonitorable)ftc).setProgressListener((ProgressListener)p);
            }
            if (this.isRange()) {
                msg.verbose("Byte range: " + this.startByte + " - " + (this.getRangeSize() > 0L ? this.endByte : ""));
                for (long skipped = 0L; skipped < this.startByte; skipped += is.skip(this.startByte)) {
                }
                ftc.writeAllData((InputStream)is, this.endByte - this.startByte + 1L);
            } else {
                ftc.writeAllData((InputStream)is);
            }
            this.copyProperties(localFile, sms, remotePath, msg);
            if (ftc instanceof FiletransferOptions.IMonitorable) {
                p.finish();
            }
        }
        finally {
            if (ftc != null) {
                try {
                    ftc.destroy();
                }
                catch (Exception e1) {
                    msg.error("Could not clean-up the filetransfer at <" + ftc.getUrl() + ">", e1);
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignored) {}
        }
        if (this.timing) {
            long duration = System.currentTimeMillis() - startTime;
            double rate = (double)localFile.length() / (double)duration;
            msg.message("Rate: " + UCC.numberFormat.format(rate) + " kB/sec.");
        }
    }

    private void copyProperties(File sourceFile, StorageClient sms, String target, MessageWriter msg) throws Exception {
        boolean x = sourceFile.canExecute();
        try {
            if (x) {
                sms.changePermissions(target, true, true, x);
            }
        }
        catch (Exception ex) {
            msg.error("Can't set exectuable flag on remote file.", ex);
        }
    }

    private void checkOK() throws FileNotFoundException {
        File[] files;
        if (!this.failOnError) {
            return;
        }
        File orig = new File(this.from);
        if (!orig.isAbsolute()) {
            orig = new File(System.getProperty("user.dir"), this.from);
        }
        if ((files = this.resolveWildCards(orig)) == null) {
            throw new FileNotFoundException("Local import '" + this.from + "' does not exist.");
        }
        for (File f : files) {
            if (f.exists()) continue;
            throw new FileNotFoundException("Local import '" + this.from + "' does not exist.");
        }
    }

    private void configure(FileTransferClient ftc, Map<String, String> params) {
        if (ftc instanceof UFTPFileTransferClient) {
            UFTPFileTransferClient u = (UFTPFileTransferClient)ftc;
            String secret = params.get("uftp.secret");
            u.setSecret(secret);
        }
    }
}

