/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.util.PropertyHelper;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.util.Mode;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.ProtocolType;

public class FileTransferBase {
    protected Properties extraParameterSource;
    protected boolean timing = false;
    protected boolean recurse = false;
    protected String from;
    protected String to;
    protected Long startByte;
    protected Long endByte;
    protected Mode mode;
    protected boolean failOnError;
    protected List<ProtocolType.Enum> preferredProtocols = new ArrayList<ProtocolType.Enum>();
    protected ProtocolType.Enum chosenProtocol = null;

    public FileTransferBase() {
        this.preferredProtocols.add(ProtocolType.BFT);
    }

    protected Map<String, String> makeExtraParameters(ProtocolType.Enum protocol, MessageWriter msg) {
        Map<String, String> res;
        if (this.extraParameterSource == null) {
            res = new HashMap<String, String>();
        } else {
            String p = String.valueOf(protocol);
            PropertyHelper ph = new PropertyHelper((Map)this.extraParameterSource, new String[]{p, p.toLowerCase()});
            res = ph.getFilteredMap();
        }
        if (res.size() > 0) {
            msg.verbose("Have " + res.size() + " extra parameters for protocol " + protocol);
        }
        return res;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public List<ProtocolType.Enum> getPreferredProtocols() {
        return this.preferredProtocols;
    }

    public void setPreferredProtocols(List<ProtocolType.Enum> preferredProtocols) {
        this.preferredProtocols = preferredProtocols;
    }

    public void setExtraParameterSource(Properties properties) {
        this.extraParameterSource = properties;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    protected boolean isValidDirectory(String remotePath, StorageClient sms) {
        boolean result = false;
        if (!"/".equals(remotePath) && !".".equals(remotePath)) {
            try {
                GridFileType gft = sms.listProperties(remotePath);
                result = gft.getIsDirectory();
            }
            catch (Exception ex) {
                result = false;
            }
        } else {
            result = true;
        }
        return result;
    }

    public File[] resolveWildCards(File original) {
        final String name = original.getName();
        if (!this.hasWildCards(original)) {
            return new File[]{original};
        }
        File parent = original.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        FilenameFilter filter = new FilenameFilter(){
            Pattern p;
            {
                this.p = FileTransferBase.this.createPattern(name);
            }

            @Override
            public boolean accept(File file, String name2) {
                return this.p.matcher(name2).matches();
            }
        };
        return parent.listFiles(filter);
    }

    protected boolean hasWildCards(File file) {
        return this.hasWildCards(file.getName());
    }

    public boolean hasWildCards(String name) {
        return name.contains("*") || name.contains("?");
    }

    private Pattern createPattern(String nameWithWildcards) {
        String regex = nameWithWildcards.replace("?", ".").replace("*", ".*");
        return Pattern.compile(regex);
    }

    public ProtocolType.Enum getChosenProtocol() {
        return this.chosenProtocol;
    }

    public Long getStartByte() {
        return this.startByte;
    }

    public void setStartByte(Long startByte) {
        this.startByte = startByte;
    }

    public Long getEndByte() {
        return this.endByte;
    }

    public void setEndByte(Long endByte) {
        this.endByte = endByte;
    }

    protected boolean isRange() {
        return this.startByte != null && this.endByte != null;
    }

    protected long getRangeSize() {
        if (Long.MAX_VALUE == this.endByte) {
            return -1L;
        }
        return this.endByte - this.startByte;
    }
}

