/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.UFTPFileTransferClient;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.util.FileTransferBase;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.ucc.util.ProgressBar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.ProtocolType;

public class FileDownloader
extends FileTransferBase {
    private boolean showProgress = true;
    private boolean forceFileOnly = false;
    private OutputStream targetStream = null;

    public FileDownloader(String from, String to, Mode mode) {
        this(from, to, mode, true);
    }

    public FileDownloader(String from, String to, Mode mode, boolean failOnError) {
        this.to = to;
        this.from = from;
        this.mode = mode;
        this.failOnError = failOnError;
    }

    public void perform(StorageClient sms, MessageWriter msg) throws Exception {
        boolean isWildcard = this.hasWildCards(this.from);
        boolean isDirectory = false;
        GridFileType gridSource = null;
        if (isWildcard) {
            this.performWildCardExport(sms, msg);
        } else {
            gridSource = sms.listProperties(this.from);
            isDirectory = gridSource.getIsDirectory();
            if (isDirectory) {
                if (this.forceFileOnly) {
                    throw new IOException("Source is a directory");
                }
                this.performDirectoryExport(gridSource, new File(this.to), sms, msg);
            } else {
                this.download(gridSource, new File(this.to), sms, msg);
            }
        }
    }

    protected void performDirectoryExport(GridFileType directory, File targetDirectory, StorageClient sms, MessageWriter msg) throws Exception {
        GridFileType[] gridFiles;
        if (!targetDirectory.exists() || !targetDirectory.canWrite()) {
            throw new IOException("Target directory <" + this.to + "> does not exist or is not writable!");
        }
        if (!targetDirectory.isDirectory()) {
            throw new IOException("Target <" + this.to + "> is not a directory!");
        }
        for (GridFileType file : gridFiles = sms.listDirectory(directory.getPath())) {
            if (file.getIsDirectory()) {
                if (!this.recurse) {
                    msg.verbose("Skipping directory " + file.getPath());
                    continue;
                }
                File newTargetDirectory = new File(targetDirectory, this.getName(file.getPath()));
                boolean success = newTargetDirectory.mkdirs();
                if (!success) {
                    throw new IOException("Can create directory: " + newTargetDirectory.getAbsolutePath());
                }
                this.performDirectoryExport(file, newTargetDirectory, sms, msg);
                continue;
            }
            this.download(file, new File(targetDirectory, this.getName(file.getPath())), sms, msg);
        }
    }

    protected void performWildCardExport(StorageClient sms, MessageWriter msg) throws Exception {
        File targetDir;
        String dir = this.getDir(this.from);
        if (dir == null) {
            dir = "/";
        }
        GridFileType[] files = sms.find(dir, false, this.from, false, null, null);
        File file = targetDir = this.targetStream == null ? new File(this.to) : null;
        if (this.targetStream == null && !targetDir.isDirectory()) {
            throw new IOException("Target is not a directory.");
        }
        for (GridFileType f : files) {
            this.download(f, targetDir, sms, msg);
        }
    }

    private String getDir(String path) {
        return new File(path).getParent();
    }

    private String getName(String path) {
        return new File(path).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(GridFileType source, File localFile, StorageClient sms, MessageWriter msg) throws Exception {
        if (source == null || source.getIsDirectory()) {
            throw new IllegalStateException("Source=" + source);
        }
        OutputStream os = this.targetStream != null ? this.targetStream : null;
        FileTransferClient ftc = null;
        try {
            String path = source.getPath();
            if (this.targetStream == null) {
                if (localFile.isDirectory()) {
                    localFile = new File(localFile, this.getName(source.getPath()));
                }
                if (this.mode.equals((Object)Mode.nooverwrite) && localFile.exists()) {
                    msg.verbose("File exists and creation mode was set to 'nooverwrite'.");
                    return;
                }
                msg.verbose("Downloading remote file '" + sms.getUrl() + "#/" + path + "' -> " + localFile.getAbsolutePath());
                os = new FileOutputStream(localFile.getAbsolutePath(), this.mode.equals((Object)Mode.append));
            }
            this.chosenProtocol = sms.findSupportedProtocol(this.preferredProtocols.toArray(new ProtocolType.Enum[this.preferredProtocols.size()]));
            Map<String, String> extraParameters = this.makeExtraParameters(this.chosenProtocol, msg);
            ftc = sms.getExport(path, extraParameters, new ProtocolType.Enum[]{this.chosenProtocol});
            this.configure(ftc, extraParameters);
            msg.verbose("File transfer URL : " + ftc.getUrl());
            ProgressBar p = null;
            if (ftc instanceof FiletransferOptions.IMonitorable && this.showProgress) {
                long size = ftc.getSourceFileSize();
                if (this.isRange()) {
                    size = this.getRangeSize();
                }
                p = new ProgressBar(localFile.getName(), size, msg);
                ((FiletransferOptions.IMonitorable)ftc).setProgressListener((ProgressListener)p);
            }
            long startTime = System.currentTimeMillis();
            if (this.isRange()) {
                if (!(ftc instanceof FiletransferOptions.SupportsPartialRead)) {
                    throw new Exception("Byte range is defined but protocol does not allow partial read! Please choose a different protocol!");
                }
                msg.verbose("Byte range: " + this.startByte + " - " + (this.getRangeSize() > 0L ? this.endByte : ""));
                FiletransferOptions.SupportsPartialRead pReader = (FiletransferOptions.SupportsPartialRead)ftc;
                pReader.readPartial(this.startByte.longValue(), this.endByte - this.startByte + 1L, os);
            } else {
                ftc.readAllData(os);
            }
            if (p != null) {
                p.finish();
            }
            if (this.timing) {
                long duration = System.currentTimeMillis() - startTime;
                double rate = (double)localFile.length() / (double)duration;
                msg.message("Rate: " + UCC.numberFormat.format(rate) + " kB/sec.");
            }
            if (this.targetStream == null) {
                this.copyProperties(source, localFile, msg);
            }
        }
        finally {
            try {
                if (this.targetStream == null && os != null) {
                    os.close();
                }
            }
            catch (Exception ignored) {}
            if (ftc != null) {
                try {
                    ftc.destroy();
                }
                catch (Exception e1) {
                    msg.error("Could not destroy the filetransfer client", e1);
                }
            }
        }
    }

    private void copyProperties(GridFileType source, File localFile, MessageWriter msg) throws Exception {
        try {
            localFile.setExecutable(source.getPermissions().getExecutable());
        }
        catch (Exception ex) {
            msg.error("Can't set 'executable' flag for " + localFile.getName(), ex);
        }
    }

    private void configure(FileTransferClient ftc, Map<String, String> params) {
        if (ftc instanceof UFTPFileTransferClient) {
            UFTPFileTransferClient u = (UFTPFileTransferClient)ftc;
            String secret = params.get("uftp.secret");
            u.setSecret(secret);
        }
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void setForceFileOnly(boolean forceFileOnly) {
        this.forceFileOnly = forceFileOnly;
    }

    public void setTargetStream(OutputStream targetStream) {
        this.targetStream = targetStream;
    }
}

