/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.util;

import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.DefaultMessageWriter;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.runner.ApplicationRequirement;
import de.fzj.unicore.ucc.runner.ExecutionEnvironmentRequirement;
import de.fzj.unicore.ucc.runner.OSRequirement;
import de.fzj.unicore.ucc.runner.Requirement;
import de.fzj.unicore.ucc.util.FileDownloader;
import de.fzj.unicore.ucc.util.FileUploader;
import de.fzj.unicore.ucc.util.JSONUtil;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.ucc.util.UnitParser;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.jsdl.extensions.ArgumentDocument;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDocument;
import eu.unicore.jsdl.extensions.IgnoreFailureDocument;
import eu.unicore.jsdl.extensions.ResourceRequestDocument;
import eu.unicore.jsdl.extensions.UserCmdType;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CreationFlagEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemTypeEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.ArgumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.unigrids.services.atomic.types.ProtocolType;

public class Builder {
    private static final Logger logger = Logger.getLogger((String)Builder.class.getName());
    private List<FileUploader> imports;
    private List<FileDownloader> exports;
    private JobDefinitionDocument job;
    private JSONObject json;
    private MessageWriter msg = new DefaultMessageWriter();
    private IRegistryQuery registry = null;
    private IClientConfiguration security = null;
    private String jsonString;
    private final Set<Requirement> requirements = new HashSet<Requirement>();
    private final File sourceFile;
    private boolean initialised;
    private boolean checkLocalFiles = true;
    private static final String credentialTemplate = "<ac:Credential xmlns:ac=\"http://schemas.ogf.org/hpcp/2007/11/ac\"><wsse:UsernameToken xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"><wsse:Username>%1s</wsse:Username>\n<wsse:Password>%2s</wsse:Password>\n</wsse:UsernameToken>\n</ac:Credential>";
    static final String[] knownOSs = new String[]{"LINUX", "MACOS", "AIX", "FreeBSD", "NetBSD", "Solaris", "WINNT", "IRIX", "HPUX", "Unknown"};
    static String lineSep = System.getProperty("line.separator");

    public Builder(File jsonFile) throws Exception {
        this.sourceFile = jsonFile;
    }

    public Builder(String jsonString) throws Exception {
        this.jsonString = jsonString;
        this.sourceFile = null;
    }

    public void setRegistry(IRegistryQuery registry) {
        this.registry = registry;
    }

    public void setSecurityProperties(IClientConfiguration sec) {
        this.security = sec;
    }

    public void setMessageWriter(MessageWriter msg) {
        this.msg = msg;
    }

    public Builder() throws Exception {
        this.sourceFile = null;
        this.exports = new ArrayList<FileDownloader>();
        this.imports = new ArrayList<FileUploader>();
        this.jsonString = "{}";
        this.json = new JSONObject(this.jsonString);
        this.json.put("Output", (Object)".");
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJsonString() throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.sourceFile.getAbsolutePath());
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            String l = null;
            StringBuilder b = new StringBuilder();
            while ((l = r.readLine()) != null) {
                b.append(l + "\n");
            }
            this.jsonString = b.toString();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private synchronized void build() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        try {
            if (this.sourceFile != null) {
                this.readJsonString();
            }
            this.json = new JSONObject(this.jsonString);
        }
        catch (IOException ex) {
            this.msg.error("Error building job", ex);
            throw new RuntimeException(ex);
        }
        catch (JSONException ex) {
            String message = JSONUtil.makeParseErrorMessage(this.jsonString, ex);
            this.msg.error(message, ex);
            throw new RuntimeException(ex);
        }
        try {
            this.imports = this.getLocalImports(this.json.optJSONArray("Imports"));
            this.exports = this.getLocalExports(this.json.optJSONArray("Exports"));
        }
        catch (Exception ex) {
            this.msg.error("Error building imports/exports for job", ex);
            throw new RuntimeException(ex);
        }
        try {
            this.extractRequirements();
        }
        catch (Exception ex) {
            this.msg.error("Error building job requirements", ex);
            throw new RuntimeException(ex);
        }
    }

    private void extractRequirements() {
        JSONObject ee;
        String os;
        if (this.job != null) {
            this.extractFromJSDL();
            return;
        }
        String appName = JSONUtil.getString(this.json, "ApplicationName");
        String appVersion = JSONUtil.getString(this.json, "ApplicationVersion");
        if (appName != null) {
            ApplicationRequirement appRequired = new ApplicationRequirement(appName, appVersion);
            this.requirements.add(appRequired);
        }
        if ((os = JSONUtil.getString(this.json, "Operating system")) != null) {
            OperatingSystemTypeEnumeration.Enum osType = OperatingSystemTypeEnumeration.Enum.forString((String)os);
            if (osType != null) {
                this.requirements.add(new OSRequirement(osType));
            } else {
                this.msg.error("Operating system " + os + " not recognized (not defined in JSDL).", null);
            }
        }
        if ((ee = this.json.optJSONObject("Execution environment")) != null) {
            String name = ee.optString("Name");
            String version = JSONUtil.getString(ee, "Version");
            this.requirements.add(new ExecutionEnvironmentRequirement(name, version));
        }
    }

    private void extractFromJSDL() {
        try {
            String appName = this.job.getJobDefinition().getJobDescription().getApplication().getApplicationName();
            String appVersion = this.job.getJobDefinition().getJobDescription().getApplication().getApplicationVersion();
            if (appName != null) {
                ApplicationRequirement appRequired = new ApplicationRequirement(appName, appVersion);
                this.requirements.add(appRequired);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            OperatingSystemTypeEnumeration.Enum osType = this.job.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemType().getOperatingSystemName();
            if (osType != null) {
                this.requirements.add(new OSRequirement(osType));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void makeJob() throws Exception {
        String email;
        String jobDescription;
        JobDescriptionType jd = JobDescriptionType.Factory.newInstance();
        try {
            jd.setApplication(this.makeApplication(this.json));
        }
        catch (Exception e) {
            this.msg.error("", e);
        }
        String jobName = this.getProperty("Name");
        if (jobName == null) {
            jobName = this.getApplicationName() == null ? "UNICORE_Job" : this.getApplicationName();
        }
        jd.addNewJobIdentification().setJobName(jobName);
        String jobProject = this.getProperty("Project");
        if (jobProject != null) {
            jd.getJobIdentification().addJobProject(jobProject);
        }
        if ((jobDescription = this.getProperty("Description")) != null) {
            if (jd.getJobIdentification() == null) {
                jd.addNewJobIdentification();
            }
            jd.getJobIdentification().setDescription(jobDescription);
        }
        if ((email = this.getProperty("User email")) != null) {
            if (jd.getJobIdentification() == null) {
                jd.addNewJobIdentification();
            }
            jd.getJobIdentification().addJobAnnotation("User email: " + email);
        }
        try {
            String notBefore = this.json.getString("Not before");
            if (jd.getJobIdentification() == null) {
                jd.addNewJobIdentification();
            }
            jd.getJobIdentification().addJobAnnotation("notBefore: " + notBefore);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            JSONArray a = this.json.getJSONArray("Tags");
            if (jd.getJobIdentification() == null) {
                jd.addNewJobIdentification();
            }
            for (int i = 0; i < a.length(); ++i) {
                jd.getJobIdentification().addJobAnnotation(a.getString(i));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jd.setResources(this.makeResources((JSONObject)this.json.get("Resources")));
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<DataStagingType> staging = new ArrayList<DataStagingType>();
        this.addStageIn(staging, this.json.optJSONArray("Imports"));
        this.addStageIn(staging, this.json.optJSONArray("Stage in"));
        this.addStageOut(staging, this.json.optJSONArray("Exports"));
        this.addStageOut(staging, this.json.optJSONArray("Stage out"));
        jd.setDataStagingArray(staging.toArray(new DataStagingType[staging.size()]));
        try {
            jd = this.insertExecutionEnvironment(jd, this.json.optJSONObject("Execution environment"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error adding execution environment", e);
        }
        this.job = JobDefinitionDocument.Factory.newInstance();
        this.job.addNewJobDefinition().setJobDescription(jd);
    }

    private void addStageIn(List<DataStagingType> staging, JSONArray j) throws IllegalArgumentException {
        if (j == null) {
            return;
        }
        for (int i = 0; i < j.length(); ++i) {
            try {
                Location l;
                JSONObject jObj = j.getJSONObject(i);
                String target = JSONUtil.getString(jObj, "To");
                String source = JSONUtil.getString(jObj, "From");
                if (source == null) {
                    source = JSONUtil.getString(jObj, "File");
                }
                if ((l = new Location(source, this.registry, this.security, this.msg)).isLocal()) continue;
                if (this.registry != null) {
                    String resolved;
                    source = resolved = l.resolve();
                }
                DataStagingDocument dsd = DataStagingDocument.Factory.newInstance();
                DataStagingType d = dsd.addNewDataStaging();
                d.setFileName(target);
                d.addNewSource().setURI(source);
                this.insertCommonDataStagingOptions(dsd, jObj);
                staging.add(d);
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Stage-in specification invalid. Syntax: \"From: <location>, To: <uspacefile>, Mode: overwrite|append|nooverwrite\"", e);
            }
        }
    }

    private void addStageOut(List<DataStagingType> staging, JSONArray j) throws IllegalArgumentException {
        if (j == null) {
            return;
        }
        for (int i = 0; i < j.length(); ++i) {
            try {
                String target;
                Location l;
                JSONObject jObj = j.getJSONObject(i);
                String source = JSONUtil.getString(jObj, "From");
                if (source == null) {
                    source = JSONUtil.getString(jObj, "File");
                }
                if ((l = new Location(target = jObj.getString("To"), this.registry, this.security, this.msg)).isLocal()) continue;
                if (this.registry != null) {
                    String resolved;
                    target = resolved = l.resolve();
                }
                DataStagingDocument dsd = DataStagingDocument.Factory.newInstance();
                DataStagingType d = dsd.addNewDataStaging();
                d.setFileName(source);
                d.addNewTarget().setURI(target);
                this.insertCommonDataStagingOptions(dsd, jObj);
                staging.add(d);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Stage-out specification invalid. Syntax: \"From: <uspacefile>, To: <location>, Mode: overwrite|append|nooverwrite\"", e);
            }
        }
    }

    private void insertCommonDataStagingOptions(DataStagingDocument dsd, JSONObject spec) {
        Boolean failOnError;
        JSONObject cred;
        DataStagingType d = dsd.getDataStaging();
        String creation = JSONUtil.getString(spec, "Mode", "overwrite");
        if ("append".equalsIgnoreCase(creation)) {
            d.setCreationFlag(CreationFlagEnumeration.APPEND);
        } else if ("nooverwrite".equalsIgnoreCase(creation)) {
            d.setCreationFlag(CreationFlagEnumeration.DONT_OVERWRITE);
        } else {
            d.setCreationFlag(CreationFlagEnumeration.OVERWRITE);
        }
        String fs = spec.optString("Filesystem", null);
        if (fs != null) {
            d.setFilesystemName(fs);
        }
        if ((cred = spec.optJSONObject("Credentials")) != null) {
            try {
                WSUtilities.append((XmlObject)this.makeCredentials(cred), (XmlObject)d);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't parse Credentials structure", e);
            }
        }
        if (!(failOnError = Boolean.valueOf(Boolean.parseBoolean(JSONUtil.getString(spec, "FailOnError", "true")))).booleanValue()) {
            IgnoreFailureDocument ifd = IgnoreFailureDocument.Factory.newInstance();
            ifd.setIgnoreFailure(true);
            WSUtilities.append((XmlObject)ifd, (XmlObject)dsd);
        }
    }

    public XmlObject makeCredentials(JSONObject creds) throws Exception {
        String user = creds.optString("Username", null);
        if (user == null) {
            return null;
        }
        String pass = creds.optString("Password", null);
        return XmlObject.Factory.parse((String)String.format(credentialTemplate, user, pass));
    }

    private ResourcesType makeResources(JSONObject j) throws Exception {
        ResourcesDocument rd = ResourcesDocument.Factory.newInstance();
        ResourcesType rt = rd.addNewResources();
        Iterator it = j.keys();
        while (it.hasNext()) {
            String resource = (String)it.next();
            if ("Reservation".equals(resource)) {
                try {
                    String reservationID = j.getString("Reservation");
                    this.insertReservationID(reservationID, rd);
                }
                catch (Exception e) {
                    this.msg.error("Error processing reservation id", e);
                }
                continue;
            }
            if ("Operating system".equals(resource)) {
                String os = JSONUtil.getString(j, "Operating system");
                if (os == null) continue;
                OperatingSystemTypeEnumeration.Enum osType = this.getOSType(os);
                if (osType != null) {
                    rt.addNewOperatingSystem().addNewOperatingSystemType().setOperatingSystemName(osType);
                    this.requirements.add(new OSRequirement(osType));
                    continue;
                }
                this.msg.error("Operating system " + os + " not recognized (not defined in JSDL).", null);
                continue;
            }
            if ("Runtime".equals(resource)) {
                String runtime = j.getString("Runtime");
                if (runtime == null) continue;
                runtime = String.valueOf(UnitParser.getTimeParser(1).getDoubleValue(runtime));
                rt.addNewIndividualCPUTime().addNewExact().setStringValue(runtime);
                continue;
            }
            if ("Memory".equals(resource)) {
                String memory = j.getString("Memory");
                if (memory == null) continue;
                memory = String.valueOf(UnitParser.getCapacitiesParser(1).getDoubleValue(memory));
                rt.addNewIndividualPhysicalMemory().addNewExact().setStringValue(memory);
                continue;
            }
            if ("CPUs".equals(resource)) {
                String totalCPUs = j.getString("CPUs");
                if (totalCPUs == null) continue;
                rt.addNewTotalCPUCount().addNewExact().setStringValue(totalCPUs);
                continue;
            }
            if ("Nodes".equals(resource)) {
                String nodes = j.getString("Nodes");
                if (nodes == null) continue;
                rt.addNewTotalResourceCount().addNewExact().setStringValue(nodes);
                continue;
            }
            if ("CPUsPerNode".equals(resource)) {
                String cpus = j.getString("CPUsPerNode");
                if (cpus == null) continue;
                rt.addNewIndividualCPUCount().addNewExact().setStringValue(cpus);
                continue;
            }
            try {
                String req = j.getString(resource);
                this.insertResourceRequest(resource, req, rd);
            }
            catch (Exception e) {
                this.msg.error("Error processing resource request for <" + resource + ">", e);
            }
        }
        return rt;
    }

    private void insertResourceRequest(String name, String value, ResourcesDocument target) throws Exception {
        ResourceRequestDocument rrd = ResourceRequestDocument.Factory.newInstance();
        rrd.addNewResourceRequest().setName(name);
        rrd.getResourceRequest().setValue(value);
        WSUtilities.append((XmlObject)rrd, (XmlObject)target);
    }

    private void insertReservationID(String id, ResourcesDocument target) throws Exception {
        String resID = "<u6rr:ReservationReference xmlns:u6rr=\"http://www.unicore.eu/unicore/xnjs\">" + id + "</u6rr:ReservationReference>";
        XmlObject o = XmlObject.Factory.parse((String)resID);
        WSUtilities.append((XmlObject)o, (XmlObject)target);
    }

    private JobDescriptionType insertExecutionEnvironment(JobDescriptionType job, JSONObject jsonEE) throws Exception {
        String userPost;
        String userPre;
        JSONArray post;
        JSONArray pre;
        JSONArray opts;
        if (jsonEE == null) {
            return job;
        }
        ExecutionEnvironmentDocument eed = ExecutionEnvironmentDocument.Factory.newInstance();
        ExecutionEnvironmentDocument.ExecutionEnvironment ee = eed.addNewExecutionEnvironment();
        String name = (String)jsonEE.get("Name");
        ee.setName(name);
        JSONObject args = jsonEE.optJSONObject("Arguments");
        if (args != null) {
            Iterator it = args.keys();
            while (it.hasNext()) {
                name = (String)it.next();
                String value = args.getString(name);
                ArgumentDocument.Argument a = ee.addNewArgument();
                a.setName(name);
                a.setValue(value);
            }
        }
        if ((opts = jsonEE.optJSONArray("Options")) != null) {
            for (int i = 0; i < opts.length(); ++i) {
                ee.addNewOption().setName(opts.getString(i));
            }
        }
        if ((pre = jsonEE.optJSONArray("Precommands")) != null) {
            for (int i = 0; i < pre.length(); ++i) {
                ee.addNewPreCommand().setName(pre.getString(i));
            }
        }
        if ((post = jsonEE.optJSONArray("Postcommands")) != null) {
            for (int i = 0; i < post.length(); ++i) {
                ee.addNewPostCommand().setName(post.getString(i));
            }
        }
        if ((userPre = JSONUtil.getString(jsonEE, "User precommand")) != null) {
            UserCmdType uct = UserCmdType.Factory.newInstance();
            uct.setStringValue(userPre);
            ee.setUserPreCommand(uct);
        }
        if ((userPost = JSONUtil.getString(jsonEE, "User postcommand")) != null) {
            UserCmdType uct = UserCmdType.Factory.newInstance();
            uct.setStringValue(userPost);
            ee.setUserPostCommand(uct);
        }
        JobDescriptionDocument d = JobDescriptionDocument.Factory.newInstance();
        d.setJobDescription(job);
        WSUtilities.append((XmlObject)eed, (XmlObject)d);
        return d.getJobDescription();
    }

    private ApplicationType makeApplication(JSONObject j) throws Exception {
        JSONObject params;
        JSONArray array;
        String val;
        ApplicationDocument ad = ApplicationDocument.Factory.newInstance();
        ApplicationType app = ad.addNewApplication();
        String val2 = JSONUtil.getString(j, "ApplicationVersion");
        if (val2 != null) {
            app.setApplicationVersion(val2);
        }
        if ((val = JSONUtil.getString(j, "ApplicationName")) != null) {
            app.setApplicationName(val);
            ApplicationRequirement appRequired = new ApplicationRequirement(val, val2);
            this.requirements.add(appRequired);
        }
        POSIXApplicationDocument pd = POSIXApplicationDocument.Factory.newInstance();
        POSIXApplicationType p = pd.addNewPOSIXApplication();
        val = JSONUtil.getString(j, "Executable");
        if (val != null) {
            p.addNewExecutable().setStringValue(val);
        }
        if ((array = j.optJSONArray("Arguments")) != null) {
            p.setArgumentArray(this.makeArgs(array));
        }
        if ((array = j.optJSONArray("Environment")) != null) {
            p.setEnvironmentArray(this.makeEnvironment(array));
        }
        if ((params = j.optJSONObject("Parameters")) != null) {
            Iterator it = params.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                val = params.getString(key);
                EnvironmentType et = p.addNewEnvironment();
                et.setName(key);
                et.setStringValue(val);
            }
        }
        if ((val = JSONUtil.getString(j, "User name")) != null) {
            p.addNewUserName().setStringValue(val);
        }
        if ((val = JSONUtil.getString(j, "Group")) != null) {
            p.addNewGroupName().setStringValue(val);
        }
        if ((val = JSONUtil.getString(j, "Stdin")) != null) {
            p.addNewInput().setStringValue(val);
        }
        if ((val = JSONUtil.getString(j, "Stdout")) != null) {
            p.addNewOutput().setStringValue(val);
        }
        if ((val = JSONUtil.getString(j, "Stderr")) != null) {
            p.addNewError().setStringValue(val);
        }
        WSUtilities.append((XmlObject)pd, (XmlObject)ad);
        return app;
    }

    private ArgumentType[] makeArgs(JSONArray j) {
        ArgumentType[] args = new ArgumentType[j.length()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ArgumentType.Factory.newInstance();
            try {
                args[i].setStringValue(j.getString(i));
                continue;
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("Error parsing argument " + i + " in argument array! ", ex);
            }
        }
        return args;
    }

    private EnvironmentType[] makeEnvironment(JSONArray j) {
        EnvironmentType[] args = new EnvironmentType[j.length()];
        for (int i = 0; i < args.length; ++i) {
            try {
                String val = j.getString(i);
                String[] split = val.split("=", 2);
                args[i] = EnvironmentType.Factory.newInstance();
                args[i].setName(split[0].trim());
                if (split.length > 1) {
                    args[i].setStringValue(split[1].trim());
                    continue;
                }
                args[i].setStringValue("");
                continue;
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("Error parsing entry " + i + " in environment array! ", ex);
            }
        }
        return args;
    }

    private List<FileUploader> getLocalImports(JSONArray j) throws IllegalArgumentException, FileNotFoundException {
        ArrayList<FileUploader> result = new ArrayList<FileUploader>();
        if (j != null) {
            for (int i = 0; i < j.length(); ++i) {
                String target;
                String source;
                Mode mode = Mode.overwrite;
                boolean failOnError = true;
                try {
                    JSONObject jObj = j.getJSONObject(i);
                    source = JSONUtil.getString(jObj, "From");
                    if (source == null) {
                        source = JSONUtil.getString(jObj, "File");
                    }
                    target = JSONUtil.getString(jObj, "To");
                    String creation = JSONUtil.getString(jObj, "Mode", "overwrite");
                    failOnError = Boolean.parseBoolean(JSONUtil.getString(jObj, "FailOnError", "true"));
                    mode = Mode.valueOf(creation);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("File import specification invalid. Syntax: \"From: <localfile>, To: <uspacefile>, Mode: overwrite|append|nooverwrite\"");
                }
                if (source == null || target == null) {
                    throw new IllegalArgumentException("File import specification invalid. Syntax: \"From: <localfile>, To: <uspacefile>, Mode: overwrite|append|nooverwrite\"");
                }
                Location l = new Location(source, this.registry, this.security, this.msg, false);
                if (!l.isLocal()) continue;
                result.add(new FileUploader(source, target, mode, failOnError &= this.checkLocalFiles));
                this.msg.verbose("Local file import: " + source + " -> " + target);
            }
        }
        return result;
    }

    private List<FileDownloader> getLocalExports(JSONArray j) throws IllegalArgumentException {
        ArrayList<FileDownloader> result = new ArrayList<FileDownloader>();
        if (j != null) {
            for (int i = 0; i < j.length(); ++i) {
                String target;
                String source;
                Mode mode = Mode.overwrite;
                boolean failOnError = true;
                try {
                    JSONObject jObj = j.getJSONObject(i);
                    source = JSONUtil.getString(jObj, "From");
                    if (source == null) {
                        source = JSONUtil.getString(jObj, "File");
                    }
                    target = jObj.getString("To");
                    String creation = JSONUtil.getString(jObj, "Mode", "overwrite");
                    mode = Mode.valueOf(creation);
                    failOnError = Boolean.parseBoolean(JSONUtil.getString(jObj, "FailOnError", "true"));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Local export specification invalid. Syntax: \"From: <uspacefile | u6://address>, To: <localfile>, Mode: overwrite|append|nooverwrite\"");
                }
                if (source == null || target == null) {
                    throw new IllegalArgumentException("Local export specification invalid. Syntax: \"From: <uspacefile | u6://address>, To: <localfile>, Mode: overwrite|append|nooverwrite\"");
                }
                Location l = new Location(target, this.registry, this.security, this.msg, false);
                if (!l.isLocal()) continue;
                result.add(new FileDownloader(source, target, mode, failOnError));
                this.msg.verbose("File export to client: " + source + " -> " + target);
            }
        }
        return result;
    }

    OperatingSystemTypeEnumeration.Enum getOSType(String os) {
        for (String o : knownOSs) {
            if (!o.equalsIgnoreCase(os)) continue;
            return OperatingSystemTypeEnumeration.Enum.forString((String)o);
        }
        return OperatingSystemTypeEnumeration.Enum.forString((String)os);
    }

    public List<FileDownloader> getExports() {
        this.build();
        return this.exports;
    }

    public List<FileUploader> getImports() {
        this.build();
        return this.imports;
    }

    public JobDefinitionDocument getJob() throws Exception {
        this.build();
        if (this.job == null) {
            this.makeJob();
        }
        return this.job;
    }

    public void setJob(JobDefinitionDocument job) throws Exception {
        this.job = job;
    }

    public void setProperty(String key, String value) {
        this.build();
        try {
            this.json.put(key, (Object)value);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public String getProperty(String key) {
        this.build();
        return JSONUtil.getString(this.json, key);
    }

    public String getProperty(String key, String defaultValue) {
        this.build();
        return JSONUtil.getString(this.json, key, defaultValue);
    }

    public void writeTo(Writer os) {
        this.build();
        try {
            os.write(this.json.toString(2) + "\n");
            os.flush();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public String toString() {
        this.build();
        try {
            return this.json.toString(2);
        }
        catch (Exception exception) {
            return super.toString() + "<invalid JSON object>";
        }
    }

    public Builder setJobName(String name) {
        try {
            this.json.put("Name", (Object)name);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder setApplication(String name, String version) {
        try {
            this.json.put("ApplicationName", (Object)name);
            if (version != null) {
                this.json.put("ApplicationVersion", (Object)version);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public String getApplicationName() {
        this.build();
        return JSONUtil.getString(this.json, "ApplicationName");
    }

    public String getApplicationVersion() {
        this.build();
        return JSONUtil.getString(this.json, "ApplicationVersion");
    }

    public Builder setExecutable(String exec) {
        try {
            this.json.put("Executable", (Object)exec);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder withImport(String from, String to) throws FileNotFoundException {
        return this.withImport(from, to, Mode.overwrite, true);
    }

    public Builder withImport(String from, String to, Mode mode, boolean failOnError) throws FileNotFoundException {
        this.imports.add(new FileUploader(from, to, mode, failOnError));
        return this;
    }

    public Builder withExport(String from, String to) {
        this.exports.add(new FileDownloader(from, to, Mode.overwrite));
        return this;
    }

    public Builder hasArgument(String arg) {
        this.build();
        this.getArgs().put((Object)arg);
        return this;
    }

    public Builder hasArguments(String[] args) {
        this.build();
        for (String a : args) {
            this.getArgs().put((Object)a);
        }
        return this;
    }

    public Builder setEnvironment(String key, String value) {
        this.build();
        this.getEnv().put((Object)(key + "=" + value));
        return this;
    }

    public Builder writeOutputTo(String outputLocation) {
        this.build();
        try {
            this.json.put("Output", (Object)outputLocation);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder asUser(String userName) {
        this.build();
        try {
            this.json.put("User name", (Object)userName);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder asProject(String project) {
        this.build();
        try {
            this.json.put("Project", (Object)project);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder setStdin(String input) {
        this.build();
        try {
            this.json.put("Stdin", (Object)input);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder setStdout(String output) {
        this.build();
        try {
            this.json.put("Stdout", (Object)output);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Builder setStderr(String error) {
        this.build();
        try {
            this.json.put("Stderr", (Object)error);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public ProtocolType.Enum[] getPreferredProtocols() {
        this.build();
        try {
            String protocolsP = this.getProperty("Preferred protocols", "");
            String[] protocols = protocolsP.split(" +");
            ProtocolType.Enum[] result = new ProtocolType.Enum[protocols.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ProtocolType.Enum.forString((String)protocols[i]);
            }
            return result;
        }
        catch (Exception e) {
            this.msg.error("Error setting up preferred protocols", e);
            return new ProtocolType.Enum[0];
        }
    }

    public Set<Requirement> getRequirements() {
        this.build();
        return this.requirements;
    }

    public String getSite() {
        return this.getProperty("Site");
    }

    public int getLifetime() {
        this.build();
        String lifetime = JSONUtil.getString(this.json, "Lifetime");
        if (lifetime != null && lifetime.length() > 0) {
            return (int)UnitParser.getTimeParser(0).getDoubleValue(lifetime);
        }
        return -1;
    }

    public Builder setSite(String site) {
        this.build();
        try {
            this.json.put("Site", (Object)site);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public void setCheckLocalFiles(boolean checkLocalFiles) {
        this.checkLocalFiles = checkLocalFiles;
    }

    private JSONArray getArgs() {
        this.build();
        try {
            return (JSONArray)this.json.get("Arguments");
        }
        catch (JSONException ex) {
            try {
                this.json.put("Arguments", (Object)new JSONArray());
                return (JSONArray)this.json.get("Arguments");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private JSONArray getEnv() {
        this.build();
        try {
            return (JSONArray)this.json.get("Environment");
        }
        catch (JSONException ex) {
            try {
                this.json.put("Environment", (Object)new JSONArray());
                return (JSONArray)this.json.get("Environment");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String getJobSample() {
        StringBuilder s = new StringBuilder();
        Builder.writeLine("{", s);
        Builder.writeLine("# example UCC job", s);
        Builder.writeLine("#", s);
        Builder.writeLine("# either application name OR executable must be given", s);
        Builder.writeLine("# all other fields are optional", s);
        Builder.writeLine("#", s);
        Builder.writeLine("  ApplicationName: \"Date\", ApplicationVersion: \"1.0\",", s);
        Builder.writeLine("# or:  Executable: \"/bin/date\",", s);
        Builder.writeLine("  Arguments: [\"-l\", \"-v\", ],", s);
        Builder.writeLine("  Parameters: { VERBOSE: true, INPUTFILE: foo.txt},", s);
        Builder.writeLine("  Environment: [\"VERBOSE=true\", \"TIMING=false\", ],", s);
        Builder.writeLine("  Stdout: stdout, Stderr: stderr, Stdin: stdin,", s);
        Builder.writeLine("  Imports: [", s);
        Builder.writeLine("    { From: \"localFile | remoteFile\", To: \"jobdirFile\", Mode: \"overwrite | append | nooverwrite\" , FailOnError: true|false },", s);
        Builder.writeLine("#   more imports of this form can be added", s);
        Builder.writeLine("  ],", s);
        Builder.writeLine("  Exports: [", s);
        Builder.writeLine("    { From: \"jobdirFile\", To: \"localFile | remoteFile\", Mode: \"overwrite | append | nooverwrite\" }, ", s);
        Builder.writeLine("#   more exports of this form can be added", s);
        Builder.writeLine("  ],", s);
        Builder.writeLine("  Name: \"my test job\",", s);
        Builder.writeLine("  User name: remotelogin,", s);
        Builder.writeLine("  User email: foo@bar.org,", s);
        Builder.writeLine("  Group: remotegroup,", s);
        Builder.writeLine("  Project: some_project,", s);
        Builder.writeLine("  Tags: [\"testing\", \"demo job\"] ,", s);
        Builder.writeLine("  Not before: \"2011-11-11T12:00:00+200\",", s);
        Builder.writeLine("  Site: \"DEMO-SITE\",", s);
        Builder.writeLine("  Resources: {", s);
        Builder.writeLine("    CPUs: 4,", s);
        Builder.writeLine("#   alternatively: ", s);
        Builder.writeLine("    Nodes: 2,", s);
        Builder.writeLine("    CPUsPerNode: 2,", s);
        Builder.writeLine("    Memory: 2048M,", s);
        Builder.writeLine("    Runtime: 4h,", s);
        Builder.writeLine("    Operating system: LINUX,", s);
        Builder.writeLine("    Reservation: 1234,", s);
        Builder.writeLine("  },", s);
        Builder.writeLine("  Execution environment: {", s);
        Builder.writeLine("    Name: OpenMPI,", s);
        Builder.writeLine("    Arguments: {", s);
        Builder.writeLine("      Processors: 2,", s);
        Builder.writeLine("    },", s);
        Builder.writeLine("    Options: [ VERBOSE, ],", s);
        Builder.writeLine("    Precommands: [ MODULE_TRACE, ],", s);
        Builder.writeLine("    Postcommands: [ CLEANUP, ],", s);
        Builder.writeLine("    User precommand: \"touch /home/myname/somefile\" ,", s);
        Builder.writeLine("    User postcommand: \"touch /home/myname/someotherfile\" ,", s);
        Builder.writeLine("  },", s);
        Builder.writeLine("  Preferred protocols: \"BFT RBYTEIO\",", s);
        Builder.writeLine("  Output: \"localdir\",", s);
        Builder.writeLine("  Lifetime: 24h,", s);
        Builder.writeLine("  Update interval: 10,", s);
        Builder.writeLine("}", s);
        return s.toString();
    }

    public static boolean isValidJSDL(JobDefinitionDocument jdd, MessageWriter msg) {
        boolean isValid;
        ArrayList validationErrors = new ArrayList();
        XmlOptions opts = new XmlOptions();
        opts.setErrorListener(validationErrors);
        jdd.validate(opts);
        int numErrors = validationErrors.size();
        boolean bl = isValid = numErrors == 0;
        if (numErrors > 0 && msg != null) {
            msg.message("There were " + numErrors + " JSDL validation errors, check client log, or re-run in verbose mode " + "to see more details.");
            for (int i = 0; i < numErrors; ++i) {
                msg.verbose(String.valueOf(validationErrors.get(i)));
            }
        }
        return isValid;
    }

    private static void writeLine(String line, StringBuilder sb) {
        sb.append(line);
        sb.append(lineSep);
    }
}

