/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.shell;

import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.UCC;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jline.Completor;
import org.apache.commons.cli.Option;

public class UCCCompletor
implements Completor {
    final String[] cmds;

    UCCCompletor(String[] cmds) {
        this.cmds = cmds;
    }

    public int complete(String buffer, int cursor, List completions) {
        completions.clear();
        String[] parts = buffer.split(" +");
        if (cursor <= parts[0].length()) {
            return this.completeUCCCommand(parts, completions);
        }
        try {
            Command command = UCC.getCommand(parts[0]);
            return this.completeCommand(command, buffer, cursor, completions);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int completeUCCCommand(String[] parts, List completions) {
        String cmd = parts[0];
        completions.clear();
        ArrayList<String> matches = new ArrayList<String>();
        for (String c : this.cmds) {
            if (!c.startsWith(cmd)) continue;
            matches.add(c);
        }
        if (matches.size() > 1) {
            completions.addAll(matches);
        } else if (matches.size() > 0) {
            completions.add((String)matches.get(0) + " ");
        }
        Collections.sort(completions);
        return 0;
    }

    protected int completeCommand(Command command, String buffer, int cursor, List completions) {
        try {
            String base;
            String[] parts = buffer.split(" +");
            String lastToken = parts[parts.length - 1];
            boolean empty = buffer.endsWith(" ");
            String string = base = empty ? buffer : buffer.substring(0, buffer.lastIndexOf(lastToken));
            if (!empty && lastToken.startsWith("-")) {
                boolean longOpts = lastToken.startsWith("--");
                while (lastToken.startsWith("-")) {
                    lastToken = lastToken.substring(1);
                }
                Collection opts = command.getOptions().getOptions();
                for (Option o : opts) {
                    if (longOpts) {
                        if (!o.getLongOpt().startsWith(lastToken)) continue;
                        completions.add(base + "--" + o.getLongOpt() + " ");
                        continue;
                    }
                    if (!o.getOpt().startsWith(lastToken)) continue;
                    completions.add(base + "-" + o.getOpt() + " ");
                }
                return 0;
            }
            File parent = null;
            String pattern = null;
            if (empty) {
                parent = new File(".");
                pattern = "";
            } else {
                File f = new File(lastToken);
                parent = f.getParentFile();
                pattern = f.getName();
                if (f.isDirectory() && lastToken.endsWith("/")) {
                    parent = f;
                    pattern = "";
                }
            }
            return this.completeFileName(base, parent, pattern, cursor, completions);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ex.printStackTrace();
            return -1;
        }
    }

    protected int completeFileName(String base, File parent, String filePattern, int cursor, List completions) {
        try {
            File[] children;
            File f = new File(filePattern);
            final String fileName = f.getName();
            if (parent == null) {
                parent = new File(".");
            }
            FilenameFilter ff = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(fileName);
                }
            };
            for (File child : children = parent.listFiles(ff)) {
                String completion = f.isAbsolute() ? child.getAbsolutePath() : child.getPath();
                String compl = base + completion;
                if (children.length == 1) {
                    compl = base + completion + (child.isDirectory() ? "/" : " ");
                }
                completions.add(compl);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return 0;
    }
}

