/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.shell;

import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import de.fzj.unicore.ucc.shell.UCCCompletor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import jline.Completor;
import jline.ConsoleReader;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;

public class Shell
extends ActionBase {
    public static final String OPT_FILE = "f";
    public static final String OPT_FILE_LONG = "file";
    private File commandFile = null;

    @Override
    public String getCommandGroup() {
        return super.getCommandGroup();
    }

    @Override
    public String getDescription() {
        return "start an interactive UCC session";
    }

    @Override
    public String getName() {
        return "shell";
    }

    @Override
    public String getSynopsis() {
        return "Starts an interactive UCC session that allows you to multiple run UCC commands.";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_FILE_LONG);
        OptionBuilder.withDescription((String)"Read input from this file instead stdin");
        OptionBuilder.withArgName((String)"Commandsfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)OPT_FILE));
    }

    @Override
    public void process() {
        super.process();
        String fileName = this.getOption(OPT_FILE_LONG, OPT_FILE);
        if (fileName != null) {
            this.commandFile = new File(fileName);
        }
        this.run();
    }

    public void run() {
        Command.quitAfterPrintingUsage = false;
        ConsoleReader is = null;
        if (this.commandFile != null) {
            try {
                is = new ConsoleReader((InputStream)new FileInputStream(this.commandFile), (Writer)new PrintWriter(System.out));
            }
            catch (IOException ex) {
                this.error("Error accessing command file.", ex);
                this.endProcessing(1);
            }
        } else {
            try {
                is = new ConsoleReader();
                String[] cmd = UCC.cmds.keySet().toArray(new String[UCC.cmds.keySet().size()]);
                is.addCompletor((Completor)new UCCCompletor(cmd));
            }
            catch (IOException ex) {
                this.error("Can't read from console.", ex);
                this.endProcessing(1);
            }
        }
        try {
            System.out.println("UCC " + UCC.getVersion() + ", http://www.unicore.eu");
            System.out.print("Welcome to the UCC shell. Enter 'help' for a list of commands. Enter 'exit' to quit.");
            while (true) {
                String s;
                System.out.println();
                String string = s = this.commandFile != null ? is.readLine() : is.readLine("ucc>");
                if (s == null) {
                    s = "exit";
                }
                if ("exit".equalsIgnoreCase(s = s.trim())) {
                    this.message("");
                    this.message("Goodbye.");
                    return;
                }
                if ("help".equalsIgnoreCase(s)) {
                    UCC.printUsage(false);
                    continue;
                }
                this.verbose(s);
                String[] args = s.split(" +");
                if (args.length == 0) continue;
                try {
                    if (this.processSpecial(args)) continue;
                    Command cmd = UCC.initCommand(args, false);
                    if (cmd == null) {
                        this.message("No such command: " + args[0]);
                        continue;
                    }
                    if (this.verbose) {
                        this.properties.put("verbose", "true");
                    }
                    if (this.timing) {
                        this.properties.put("with-timing", "true");
                    }
                    cmd.setProperties(this.properties);
                    cmd.process();
                    cmd.postProcess();
                }
                catch (EndProcessingException epe) {
                }
                catch (ParseException pex) {
                    this.error("Error parsing commandline arguments.", pex);
                }
                catch (Exception ex) {
                    this.error("Error processing command", ex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected boolean processSpecial(String[] args) {
        String cmd = args[0];
        if ("set".equalsIgnoreCase(cmd)) {
            this.handleSet(args);
            return true;
        }
        if ("unset".equalsIgnoreCase(cmd)) {
            this.handleUnset(args);
            return true;
        }
        return false;
    }

    protected void handleSet(String[] args) {
        String cmd = args[0];
        if (!"set".equalsIgnoreCase(cmd)) {
            throw new IllegalArgumentException();
        }
        if (args.length == 1) {
            for (Object keyObj : this.properties.keySet()) {
                String key = String.valueOf(keyObj);
                String val = this.properties.getProperty(key);
                if (key.toLowerCase().contains("password")) {
                    this.message(key + "=" + "*");
                    continue;
                }
                this.message(key + "=" + val);
            }
        } else {
            for (int i = 1; i < args.length; ++i) {
                String[] v = args[i].split("=", 2);
                if (v.length != 2) {
                    throw new IllegalArgumentException("Expected key=value, got: " + args[i]);
                }
                this.properties.setProperty(v[0], v[1]);
            }
        }
    }

    protected void handleUnset(String[] args) {
        String cmd = args[0];
        if (!"unset".equalsIgnoreCase(cmd)) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < args.length; ++i) {
            this.properties.remove(args[i]);
        }
    }

    @Override
    protected boolean requireRegistry() {
        return false;
    }
}

