/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.DefaultMessageWriter;
import de.fzj.unicore.ucc.runner.SiteSelectionStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WeightedSelection
implements SiteSelectionStrategy {
    private MessageWriter msg = new DefaultMessageWriter();
    private final File weightsFile;
    private long lastAccess = 0L;
    private final Map<String, Integer> weights = new HashMap<String, Integer>();
    private final Map<String, Integer> selected = new HashMap<String, Integer>();
    public static final String DEFAULT_WEIGHT = "UCC_DEFAULT_SITE_WEIGHT";

    public WeightedSelection(File weightsFile, MessageWriter msg) {
        this.weightsFile = weightsFile;
        if (msg != null) {
            this.msg = msg;
        }
    }

    @Override
    public TSSClient select(List<TSSClient> available) {
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, TSSClient> map = new HashMap<String, TSSClient>();
        for (TSSClient tss : available) {
            try {
                String name = tss.getTargetSystemName();
                names.add(name);
                map.put(name, tss);
            }
            catch (Exception e) {
                this.msg.error("", e);
            }
        }
        return (TSSClient)map.get(this.select(map.keySet()));
    }

    public String select(Set<String> available) {
        this.checkUpdate();
        String selectedTSS = null;
        float worstRatio = -1.0f;
        for (String name : available) {
            try {
                float ratio;
                if (selectedTSS == null) {
                    selectedTSS = name;
                }
                if ((ratio = this.getRatio(name)) < 0.0f) {
                    this.selected.put(name, 0);
                    continue;
                }
                if (!(ratio < worstRatio) && !(worstRatio < 0.0f)) continue;
                worstRatio = ratio;
                selectedTSS = name;
            }
            catch (Exception e) {
                this.msg.error("", e);
            }
        }
        this.storeSelection(selectedTSS);
        return selectedTSS;
    }

    protected float getRatio(String name) {
        Integer w = this.weights.get(name);
        if (w == null) {
            w = this.weights.get(DEFAULT_WEIGHT);
        }
        if (w == 0) {
            return -1.0f;
        }
        Integer s = this.selected.get(name);
        if (s == null) {
            s = 0;
        }
        return (float)s.intValue() / (float)w.intValue();
    }

    protected synchronized void storeSelection(String name) {
        Integer val = this.selected.get(name);
        if (val != null) {
            Integer n = val;
            Integer n2 = val = Integer.valueOf(val + 1);
        } else {
            val = 1;
        }
        this.selected.put(name, val);
    }

    protected void checkUpdate() {
        if (this.lastAccess < this.weightsFile.lastModified()) {
            this.lastAccess = this.weightsFile.lastModified();
            Properties p = new Properties();
            try {
                FileInputStream fis = new FileInputStream(this.weightsFile);
                p.load(fis);
                fis.close();
            }
            catch (Exception e) {
                this.msg.error("Problem reading from site weights file", e);
                return;
            }
            for (Object oKey : p.keySet()) {
                Integer i = 1;
                String key = String.valueOf(oKey);
                try {
                    i = Integer.parseInt(p.getProperty(key));
                }
                catch (Exception e) {
                    this.msg.error("Syntax error in weights file (Format: Site name = <integer weight>", e);
                }
                this.weights.put(key, i);
                if (DEFAULT_WEIGHT.equalsIgnoreCase(key)) {
                    this.msg.verbose("Default site weight <" + i + ">");
                } else {
                    this.msg.verbose("Site <" + key + "> weight <" + i + ">");
                }
                if (this.weights.get(DEFAULT_WEIGHT) != null) continue;
                this.weights.put(DEFAULT_WEIGHT, 1);
                this.msg.verbose("Default site weight is <1> (can be changed using UCC_DEFAULT_SITE_WEIGHT)");
            }
        }
    }

    @Override
    public Map<String, Integer> getSelectionStatistics() {
        return this.selected;
    }

    public File getWeightsFile() {
        return this.weightsFile;
    }
}

