/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.Constants;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.GridTask;
import de.fzj.unicore.ucc.helpers.GridTaskResult;
import de.fzj.unicore.ucc.helpers.GridTaskTarget;
import de.fzj.unicore.ucc.helpers.TargetSystemFactoryLister;
import de.fzj.unicore.ucc.runner.RandomSelection;
import de.fzj.unicore.ucc.runner.Requirement;
import de.fzj.unicore.ucc.runner.RunnerException;
import de.fzj.unicore.ucc.runner.SiteSelectionStrategy;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TargetSystemFinder
implements Constants {
    private final IRegistryQuery registry;
    private final IClientConfiguration securityProperties;
    private final MessageWriter msg;
    private final SiteSelectionStrategy selectionStrategy;
    private final String siteName;
    private boolean checkResources = true;
    private String blackList;

    public TargetSystemFinder(IRegistryQuery registry, IClientConfiguration properties, MessageWriter msg) {
        this(registry, properties, null, null, msg);
    }

    public TargetSystemFinder(IRegistryQuery registry, IClientConfiguration properties, SiteSelectionStrategy selectionStrategy, String siteName, MessageWriter msg) {
        this.registry = registry;
        this.securityProperties = properties;
        this.msg = msg;
        this.selectionStrategy = selectionStrategy != null ? selectionStrategy : new RandomSelection();
        this.siteName = siteName;
    }

    public void setCheckResources(boolean checkResources) {
        this.checkResources = checkResources;
    }

    public void setBlackList(String blacklist) {
        this.blackList = blacklist;
    }

    public TSSClient find(final Collection<Requirement> requirements) throws RunnerException {
        try {
            final List<TSSClient> available = Collections.synchronizedList(new ArrayList());
            TargetSystemFactoryLister tsfList = new TargetSystemFactoryLister(this.registry, this.securityProperties, this.msg);
            if (this.blackList != null) {
                this.msg.verbose("Using blacklist <" + this.blackList + ">");
                String[] blacklist = this.blackList.trim().split(" ");
                tsfList.setBlacklist(blacklist);
            }
            GridTask<Boolean> task = new GridTask<Boolean>(){

                private TSFClient createClient(GridTaskTarget<Boolean> target) throws Exception {
                    EndpointReferenceType epr = target.getEpr();
                    return new TSFClient(epr.getAddress().getStringValue(), epr, TargetSystemFinder.this.securityProperties);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Boolean run(GridTaskTarget<Boolean> target) throws Exception {
                    TargetSystemFinder.this.msg.verbose("Checking " + target.getEpr().getAddress().getStringValue());
                    TSFClient tsf = this.createClient(target);
                    List tssEPRs = tsf.getAccessibleTargetSystems();
                    ErrorHolder err = new ErrorHolder();
                    if (TargetSystemFinder.this.siteName != null) {
                        String currentSite = tsf.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getName();
                        if (!TargetSystemFinder.this.siteName.equals(currentSite) || tssEPRs.size() <= 0) return Boolean.FALSE;
                        EndpointReferenceType epr = (EndpointReferenceType)tssEPRs.get(0);
                        TSSClient tss = new TSSClient(epr.getAddress().getStringValue(), epr, TargetSystemFinder.this.securityProperties);
                        TargetSystemFinder.this.msg.verbose("Using requested target system <" + TargetSystemFinder.this.siteName + ">");
                        if (TargetSystemFinder.this.checkResources && !TargetSystemFinder.this.matches(tss, requirements, err)) {
                            TargetSystemFinder.this.msg.verbose(err.message);
                            throw new RunnerException(err.code, err.message);
                        }
                        available.add(tss);
                        return Boolean.TRUE;
                    }
                    Iterator i$ = tssEPRs.iterator();
                    if (!i$.hasNext()) return Boolean.FALSE;
                    EndpointReferenceType epr = (EndpointReferenceType)i$.next();
                    TSSClient tss = new TSSClient(epr.getAddress().getStringValue(), epr, TargetSystemFinder.this.securityProperties);
                    if (TargetSystemFinder.this.checkResources) {
                        if (!TargetSystemFinder.this.matches(tss, requirements, err)) return Boolean.FALSE;
                        available.add(tss);
                        return Boolean.TRUE;
                    } else {
                        available.add(tss);
                    }
                    return Boolean.TRUE;
                }
            };
            List results = tsfList.runOnEachTSF(task);
            GridTaskResult.completeAsyncTasks(results, 10, this.msg);
            TSSClient tss = null;
            if (available.size() == 0) {
                throw new RunnerException("NoSiteAvailable", "No matching target system available (try 'connect' or check job requirements)");
            }
            tss = this.selectionStrategy.select(available);
            this.msg.verbose("Selected TSS at " + tss.getEPR().getAddress().getStringValue());
            return tss;
        }
        catch (Exception e) {
            throw new RunnerException("NoSiteAvailable", "Can't find a target system.", e);
        }
    }

    protected boolean matches(TSSClient tssClient, Collection<Requirement> requirements, ErrorHolder error) {
        try {
            if (requirements == null || requirements.size() == 0) {
                return true;
            }
            TargetSystemPropertiesDocument.TargetSystemProperties props = tssClient.getResourcePropertiesDocument().getTargetSystemProperties();
            for (Requirement r : requirements) {
                this.msg.verbose("Check requirement: " + r.getDescription());
                if (r.isFulfilled(props)) continue;
                error.code = "UnmetJobRequirements";
                error.message = "Requirement <" + r.getDescription() + "> not fulfilled on " + tssClient.getTargetSystemName();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            error.code = "SiteUnavailable";
            error.message = Log.createFaultMessage((String)"Can't contact target system", (Throwable)e);
            return false;
        }
    }

    static class ErrorHolder {
        String code;
        String message;

        ErrorHolder() {
        }
    }
}

