/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.ucc.runner.RequestQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class RunningQueue
extends RequestQueue {
    public RunningQueue(String requestDirname) throws IOException {
        super(requestDirname, true);
        if (!this.getRequestDir().canWrite()) {
            throw new IOException("Fatal: directory " + requestDirname + "must be writable.");
        }
    }

    @Override
    public boolean canAdd() {
        return this.limit == -1 || this.length() < this.limit;
    }

    @Override
    public void add(String o) throws Exception {
        super.add(o, new File(o).lastModified());
    }

    @Override
    public int length() {
        File[] files = this.requestDir.listFiles(this.getFilter());
        this.queued = files.length;
        return this.queued;
    }

    @Override
    protected FileFilter getFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".job");
            }
        };
    }
}

