/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.uas.faults.AutoStartNotSupportedException;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.actions.FileOperation;
import de.fzj.unicore.ucc.helpers.DefaultMessageWriter;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.runner.RandomSelection;
import de.fzj.unicore.ucc.runner.RunnerException;
import de.fzj.unicore.ucc.runner.SiteSelectionStrategy;
import de.fzj.unicore.ucc.runner.TargetSystemFinder;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.ucc.util.FileDownloader;
import de.fzj.unicore.ucc.util.FileUploader;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.services.atomic.types.StatusType;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Runner
implements Runnable {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private MessageWriter msg;
    private Builder builder;
    protected TSSClient tss;
    protected JobClient jobClient;
    protected Float progress;
    protected StatusType.Enum status;
    protected IRegistryQuery registry;
    protected IClientConfiguration securityProperties;
    protected SiteSelectionStrategy siteSelectionStrategy;
    protected boolean asyncMode = false;
    protected boolean checkResources = true;
    protected boolean submitOnly = false;
    protected boolean keepJob = true;
    protected boolean mustSave = false;
    protected boolean needManualJobStart = true;
    protected boolean noFetchOutcome;
    protected boolean briefOutputFiles;
    protected File output;
    protected String siteName = null;
    protected Properties properties;
    private boolean haveOutDir = false;
    protected final List<ProtocolType.Enum> preferredProtocols = new ArrayList<ProtocolType.Enum>();
    public static final String NEW = "NEW";
    public static final String STAGEIN = "STAGEIN";
    public static final String READY = "READY";
    public static final String STARTED = "STARTED";
    public static final String STAGEOUT = "STAGEOUT";
    public static final String DONE = "DONE";
    public static final String FINISHED = "FINISHED";
    public static final String ERR_UNKNOWN = "Unkown";
    public static final String ERR_INVALID_JOB_DEFINITION = "InvalidJobDefinition";
    public static final String ERR_UNMET_REQUIREMENTS = "UnmetJobRequirements";
    public static final String ERR_SITE_UNAVAILABLE = "SiteUnavailable";
    public static final String ERR_NO_SITE = "NoSiteAvailable";
    public static final String ERR_SUBMIT_FAILED = "SubmissionFailed";
    public static final String ERR_LOCAL_IMPORT_FAILED = "LocalFileImportFailed";
    public static final String ERR_START_FAILED = "JobStartFailed";
    public static final String ERR_GET_JOB_STATUS = "GettingJobStatusFailed";
    public static final String ERR_JOB_NOT_COMPLETED_SUCCESSFULLY = "JobDidNotCompleteSuccessfully";
    private static Map<String, State> states = new HashMap<String, State>();

    public Runner() {
        counter.incrementAndGet();
    }

    public Runner(IRegistryQuery registry, IClientConfiguration securityProperties, Builder builder) {
        this(registry, securityProperties, builder, new DefaultMessageWriter());
    }

    public Runner(IRegistryQuery registry, IClientConfiguration securityProperties, Builder builder, MessageWriter writer) {
        this();
        this.registry = registry;
        this.builder = builder;
        this.msg = writer;
        this.securityProperties = securityProperties;
    }

    public void setAsyncMode(boolean asyncMode) {
        this.asyncMode = asyncMode;
    }

    public void setCheckResources(boolean checkResources) {
        this.checkResources = checkResources;
    }

    public void setNoFetchOutCome(boolean flag) {
        this.noFetchOutcome = flag;
    }

    public void setSubmitOnly(boolean flag) {
        this.submitOnly = flag;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setBriefOutfileNames(boolean flag) {
        this.briefOutputFiles = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.setOutputLocation();
            if (this.siteName == null) {
                this.siteName = this.builder.getSite();
            }
            this.initPreferredProtocols();
            if (this.asyncMode) {
                this.runAsync();
            } else {
                this.runSync();
            }
        }
        finally {
            counter.decrementAndGet();
        }
    }

    protected void runAsync() {
        String state = this.builder.getProperty("state", NEW);
        State s = Runner.getState(state);
        do {
            try {
                this.mustSave = false;
                s = s.process(this);
                state = s.getName();
                this.builder.setProperty("state", state);
            }
            catch (Exception e) {
                String reason = Log.createFaultMessage((String)("Error occurred processing state <" + s.getName() + ">"), (Throwable)e);
                this.msg.error("Error processing.", e);
                this.writeFailedJobIDFile(reason);
                throw new RuntimeException(reason, e);
            }
        } while (s.autoProceedToNextState());
        if (!FINISHED.equals(state)) {
            this.writeJobIDFile();
        }
    }

    protected void runSync() {
        String state = this.builder.getProperty("state", NEW);
        do {
            State s = Runner.getState(state);
            this.msg.verbose("Job is " + state);
            try {
                s = s.process(this);
                state = s.getName();
                this.builder.setProperty("state", state);
            }
            catch (Exception e) {
                this.msg.error("Error processing.", e);
                throw new RuntimeException(e);
            }
        } while (!FINISHED.equals(state));
    }

    protected void doSubmit() throws RunnerException {
        this.findTSS();
        SubmitDocument submit = SubmitDocument.Factory.newInstance();
        submit.addNewSubmit();
        try {
            if (this.builder.getImports().size() == 0) {
                submit.getSubmit().setAutoStartWhenReady(true);
                this.needManualJobStart = false;
            }
            submit.getSubmit().setJobDefinition(this.builder.getJob().getJobDefinition());
            int lifetime = this.builder.getLifetime();
            if (lifetime > 0) {
                Calendar c = Calendar.getInstance();
                c.add(13, lifetime);
                submit.getSubmit().addNewTerminationTime().setCalendarValue(c);
            }
        }
        catch (Exception e) {
            this.msg.error("Could not setup job definition.", e);
            throw new RunnerException(ERR_INVALID_JOB_DEFINITION, "Could not setup job definition", e);
        }
        try {
            try {
                this.jobClient = this.tss.submit(submit);
            }
            catch (AutoStartNotSupportedException ase) {
                submit.getSubmit().setAutoStartWhenReady(false);
                this.needManualJobStart = true;
                this.jobClient = this.tss.submit(submit);
            }
        }
        catch (Exception e) {
            this.msg.error("Could not submit job.", e);
            throw new RunnerException(ERR_SUBMIT_FAILED, "Could not submit job", e);
        }
        String epr = this.jobClient.getEPR().getAddress().getStringValue();
        this.builder.setProperty("epr", epr);
        this.builder.setProperty("type", "job");
        this.builder.setProperty("id", WSUtilities.extractResourceID((EndpointReferenceType)this.jobClient.getEPR()));
        this.msg.verbose("Job submitted, job url: " + epr);
    }

    protected void initJobClient() {
        if (this.jobClient != null) {
            return;
        }
        try {
            String url = this.builder.getProperty("epr");
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(url);
            this.jobClient = new JobClient(url, epr, this.securityProperties);
            try {
                String id = WSUtilities.extractResourceID((EndpointReferenceType)epr);
                String log = this.jobClient.getResourcePropertiesDocument().getJobProperties().getLog();
                if (!log.contains(id)) {
                    this.msg.error("Job properties for job " + url + " do NOT MATCH expected resource ID!!", null);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            this.msg.error("Could not initialise job client.", e);
            throw new RuntimeException(e);
        }
    }

    protected void findTSS() throws RunnerException {
        TargetSystemFinder finder = new TargetSystemFinder(this.registry, this.securityProperties, this.siteSelectionStrategy, this.siteName, this.msg);
        finder.setCheckResources(this.checkResources);
        this.tss = finder.find(this.builder.getRequirements());
    }

    protected void setOutputLocation() {
        String outputLoc = this.builder.getProperty("Output");
        if (outputLoc == null) {
            outputLoc = ".";
        }
        try {
            this.output = new File(outputLoc);
            if (!this.output.exists()) {
                this.output.mkdirs();
            }
            if (!this.output.isDirectory()) {
                throw new IllegalArgumentException("<" + outputLoc + "> is not a directory.");
            }
        }
        catch (Exception e) {
            this.msg.error("Problem with <" + outputLoc + ">", e);
        }
    }

    protected boolean shouldUpdate() {
        String updateInterval = this.builder.getProperty("Update interval", "1");
        int updateInMillis = Integer.parseInt(updateInterval) * 1000;
        if (updateInMillis <= 0) {
            return true;
        }
        String lastUpdate = this.builder.getProperty("lastStatusUpdate");
        if (lastUpdate == null) {
            lastUpdate = String.valueOf(System.currentTimeMillis());
            this.builder.setProperty("lastStatusUpdate", String.valueOf(lastUpdate));
            this.mustSave = true;
        }
        long last = Long.parseLong(lastUpdate);
        long now = System.currentTimeMillis();
        if (now > last + (long)updateInMillis) {
            this.builder.setProperty("lastStatusUpdate", String.valueOf(now));
            this.mustSave = true;
            return true;
        }
        return false;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public MessageWriter getMessageWriter() {
        return this.msg;
    }

    public void setMessageWriter(MessageWriter msg) {
        this.msg = msg;
    }

    protected void doGetStdOut() throws Exception {
        String stdout = "stdout";
        try {
            stdout = this.jobClient.getResourcePropertiesDocument().getJobProperties().getStdOut();
        }
        catch (Exception e) {
            // empty catch block
        }
        FileDownloader e = new FileDownloader(stdout, stdout, Mode.overwrite, false);
        this.doExport(e);
    }

    protected void doGetStdErr() throws Exception {
        String stderr = "stderr";
        try {
            stderr = this.jobClient.getResourcePropertiesDocument().getJobProperties().getStdErr();
        }
        catch (Exception e) {
            // empty catch block
        }
        FileDownloader e = new FileDownloader(stderr, stderr, Mode.overwrite, false);
        this.doExport(e);
    }

    protected void doImport() throws RunnerException {
        this.doImport(this.builder.getImports());
    }

    protected void doImport(List<FileUploader> fu) throws RunnerException {
        for (FileUploader e : fu) {
            try {
                this.performImportFromLocal(e);
            }
            catch (RunnerException re) {
                if (ProtocolType.BFT == e.getChosenProtocol()) continue;
                this.msg.message("ERROR performing file import: " + Log.createFaultMessage((String)re.getErrorReason(), (Throwable)re.getCause()));
                this.msg.message("Re-trying import using BFT protocol");
                e.setPreferredProtocols(Arrays.asList(ProtocolType.BFT));
                this.performImportFromLocal(e);
            }
        }
    }

    protected void doExport() throws Exception {
        this.doExport(this.builder.getExports());
    }

    protected void doExport(FileDownloader ... fd) throws Exception {
        this.doExport(Arrays.asList(fd));
    }

    protected void doExport(List<FileDownloader> fd) throws Exception {
        for (FileDownloader e : fd) {
            try {
                this.performExportToLocal(e);
            }
            catch (RunnerException re) {
                if (ProtocolType.BFT == e.getChosenProtocol()) continue;
                this.msg.message("ERROR performing file export: " + Log.createFaultMessage((String)re.getErrorReason(), (Throwable)re.getCause()));
                this.msg.message("Re-trying import using BFT protocol");
                e.setPreferredProtocols(Arrays.asList(ProtocolType.BFT));
                this.performExportToLocal(e);
            }
        }
    }

    protected void performImportFromLocal(FileUploader imp) throws RunnerException {
        try {
            imp.setExtraParameterSource(this.properties);
            if (imp.getChosenProtocol() == null) {
                imp.setPreferredProtocols(this.preferredProtocols);
            }
            imp.perform(this.jobClient.getUspaceClient(), this.msg);
        }
        catch (Exception ex) {
            if (!imp.isFailOnError()) {
                String m = Log.createFaultMessage((String)("Could not perform import of local file <" + imp.getFrom() + ">, ignoring."), (Throwable)ex);
                this.msg.verbose(m);
            }
            throw new RunnerException(ERR_LOCAL_IMPORT_FAILED, "Import of local file <" + imp.getFrom() + "> failed", ex);
        }
    }

    protected void performExportToLocal(FileDownloader e) throws Exception {
        File out = new File(e.getTo());
        if (!out.isAbsolute()) {
            this.createOutfileDirectory();
            File f = new File(this.output, e.getTo());
            e.setTo(f.getAbsolutePath());
        }
        e.setExtraParameterSource(this.properties);
        if (e.getChosenProtocol() == null) {
            e.setPreferredProtocols(this.preferredProtocols);
        }
        try {
            Location l = new Location(e.getFrom(), this.registry, this.securityProperties, this.msg);
            StorageClient sms = null;
            if (!l.isLocal()) {
                EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
                epr.addNewAddress().setStringValue(l.getSmsEpr());
                sms = new StorageClient(epr, this.securityProperties);
                e.setFrom(l.getName());
            } else {
                sms = this.jobClient.getUspaceClient();
            }
            e.perform(sms, this.msg);
        }
        catch (Exception ex) {
            if (!e.isFailOnError()) {
                String m = Log.createFaultMessage((String)("Could not export file <" + e.getFrom() + ">"), (Throwable)ex);
                this.msg.verbose(m);
            }
            throw ex;
        }
    }

    protected void start() throws RunnerException {
        try {
            this.jobClient.waitUntilReady(0);
            this.jobClient.start();
            this.msg.verbose("Job started: " + this.jobClient.getEPR().getAddress().getStringValue());
        }
        catch (Exception e) {
            this.msg.error("Could not start job.", e);
            throw new RunnerException(ERR_START_FAILED, "Could not start job", e);
        }
    }

    protected void writeJobIDFile() {
        try {
            if (!this.mustSave) {
                return;
            }
            String dump = this.builder.getProperty("jobIdFile", null);
            File dumpFile = null;
            if (dump == null) {
                String loc = this.builder.getProperty("IDLocation", this.output.getAbsolutePath());
                dumpFile = new File(loc, this.getJobID() + ".job");
                dump = dumpFile.getAbsolutePath();
                this.builder.setProperty("jobIdFile", dumpFile.getAbsolutePath());
            } else {
                dumpFile = new File(dump);
            }
            FileWriter fw = new FileWriter(dumpFile);
            this.builder.writeTo(fw);
            fw.close();
            this.msg.message(dumpFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.msg.error("Could not write job ID file.", e);
        }
    }

    protected void writeFailedJobIDFile(String errorReason) {
        try {
            File dumpFile = null;
            dumpFile = new File(this.output.getAbsolutePath(), "FAILED_" + this.getJobID() + ".job");
            FileWriter fw = new FileWriter(dumpFile);
            if (errorReason != null) {
                this.builder.setProperty("ucc-errorReason", errorReason);
            }
            this.builder.writeTo(fw);
            fw.close();
            this.msg.message(dumpFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.msg.error("Could not write failed job to file.", e);
        }
    }

    protected void createOutfileDirectory() {
        if (!this.haveOutDir) {
            if (!this.briefOutputFiles) {
                String req;
                StringBuilder sb = new StringBuilder();
                String id = this.builder.getProperty("id");
                if (id != null) {
                    sb.append(id);
                }
                if ((req = this.builder.getProperty("requestName")) != null) {
                    if (id != null) {
                        sb.append('_');
                    }
                    sb.append(req);
                }
                this.output = new File(this.output, sb.toString());
                this.output.mkdirs();
            }
            this.haveOutDir = true;
        }
    }

    protected void initPreferredProtocols() {
        for (ProtocolType.Enum p : this.builder.getPreferredProtocols()) {
            this.preferredProtocols.add(p);
        }
        this.preferredProtocols.addAll(FileOperation.getPreferredProtocols(null, this.properties));
    }

    protected void getStatus(boolean printOnlyIfChanged) throws Exception {
        Float newProgress;
        Integer exit;
        boolean changed = false;
        StatusType.Enum newStatus = this.jobClient.getStatus();
        if (!newStatus.equals(this.status)) {
            changed = true;
            this.status = newStatus;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(newStatus);
        if (this.status.equals(StatusType.SUCCESSFUL) && (exit = this.jobClient.getExitCode()) != null) {
            sb.append(" exit code: ");
            sb.append(exit);
        }
        if (this.status.equals(StatusType.RUNNING) && (newProgress = this.jobClient.getProgress()) != null) {
            if (!newProgress.equals(this.progress)) {
                this.progress = newProgress;
                changed = true;
            }
            sb.append(" progress: ");
            sb.append(100.0f * this.progress.floatValue());
            sb.append('%');
        }
        if (!printOnlyIfChanged) {
            this.msg.message(sb.toString());
        } else if (changed) {
            this.msg.message(sb.toString());
        }
    }

    public String dumpJobProperties() {
        String path = null;
        try {
            String p = this.jobClient.getResourcePropertyDocument();
            File dump = new File(this.output, WSUtilities.extractResourceID((EndpointReferenceType)this.jobClient.getEPR()) + ".properties");
            FileWriter fw = new FileWriter(dump);
            fw.append(p);
            fw.close();
            path = dump.getAbsolutePath();
            this.msg.message(path);
        }
        catch (Exception e) {
            this.msg.error("Could not get job properties.", e);
        }
        return path;
    }

    public void dumpJobLog() {
        if (this.jobClient == null) {
            this.msg.verbose("No job log available, because job was not created.");
            return;
        }
        try {
            String p = this.jobClient.getResourcePropertiesDocument().getJobProperties().getLog();
            this.msg.message("Job log: ");
            this.msg.message(p);
        }
        catch (Exception e) {
            this.msg.error("Could not get job log.", e);
        }
    }

    public IRegistryQuery getRegistry() {
        return this.registry;
    }

    public void setRegistry(IRegistryQuery registry) {
        this.registry = registry;
    }

    public JobClient getJob() {
        return this.jobClient;
    }

    public void setJob(JobClient job) {
        this.jobClient = job;
    }

    public String getJobID() {
        return this.jobClient != null ? WSUtilities.extractResourceID((String)this.jobClient.getUrl()) : null;
    }

    public synchronized SiteSelectionStrategy getSiteSelectionStrategy() {
        if (this.siteSelectionStrategy == null) {
            this.siteSelectionStrategy = new RandomSelection();
        }
        return this.siteSelectionStrategy;
    }

    public synchronized void setSiteSelectionStrategy(SiteSelectionStrategy siteSelectionStrategy) {
        this.siteSelectionStrategy = siteSelectionStrategy;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List<ProtocolType.Enum> getPreferredProtocols() {
        return this.preferredProtocols;
    }

    public static int getCounter() {
        return counter.intValue();
    }

    public static State getState(String state) {
        return states.get(state);
    }

    static {
        states.put(NEW, new State(){

            @Override
            public State process(Runner r) throws Exception {
                r.doSubmit();
                r.mustSave = true;
                return Runner.getState(Runner.STAGEIN);
            }

            @Override
            public String getName() {
                return Runner.NEW;
            }

            @Override
            public boolean autoProceedToNextState() {
                return true;
            }
        });
        states.put(STAGEIN, new State(){

            @Override
            public State process(Runner r) throws RunnerException {
                r.initJobClient();
                try {
                    r.doImport();
                }
                catch (RunnerException re) {
                    r.msg.message("Data import failed, removing the job.");
                    try {
                        r.jobClient.destroy();
                    }
                    catch (Exception ex) {
                        r.msg.error("Could not cleanup job.", ex);
                    }
                    throw re;
                }
                r.mustSave = true;
                if (r.needManualJobStart) {
                    return Runner.getState(Runner.READY);
                }
                return Runner.getState(Runner.STARTED);
            }

            @Override
            public String getName() {
                return Runner.STAGEIN;
            }

            @Override
            public boolean autoProceedToNextState() {
                return true;
            }
        });
        states.put(READY, new State(){

            @Override
            public State process(Runner r) throws RunnerException {
                r.initJobClient();
                r.start();
                r.mustSave = true;
                return Runner.getState(Runner.STARTED);
            }

            @Override
            public String getName() {
                return Runner.READY;
            }

            @Override
            public boolean autoProceedToNextState() {
                return true;
            }
        });
        states.put(STARTED, new State(){

            @Override
            public State process(Runner r) throws RunnerException {
                block10: {
                    r.initJobClient();
                    if (r.asyncMode) {
                        if (!r.shouldUpdate()) {
                            return Runner.getState(Runner.STARTED);
                        }
                        try {
                            StatusType.Enum status = r.jobClient.getStatus();
                            r.msg.verbose("Status for " + r.jobClient.getEPR().getAddress().getStringValue() + ": " + status);
                            if (!StatusType.SUCCESSFUL.equals(status) && !StatusType.FAILED.equals(status)) {
                                r.builder.setProperty("Update interval", "0");
                                return Runner.getState(Runner.STARTED);
                            }
                            break block10;
                        }
                        catch (Exception ex) {
                            throw new RunnerException(Runner.ERR_GET_JOB_STATUS, "Error getting job status", ex);
                        }
                    }
                    try {
                        if (!Boolean.parseBoolean(r.builder.getProperty("DetailedStatusDisplay", "false"))) {
                            r.jobClient.waitUntilDone(0);
                        } else {
                            String status = "";
                            do {
                                status = r.jobClient.waitUntilDone(1000);
                                r.getStatus(true);
                            } while (!status.equals("SUCCESSFUL") && !status.equals("FAILED"));
                        }
                    }
                    catch (Exception e) {
                        r.msg.error("Error waiting for job to finish.", e);
                        throw new RunnerException(Runner.ERR_JOB_NOT_COMPLETED_SUCCESSFULLY, "Error waiting for job to finish.", e);
                    }
                }
                r.mustSave = true;
                return Runner.getState(Runner.STAGEOUT);
            }

            @Override
            public String getName() {
                return Runner.STARTED;
            }

            @Override
            public boolean autoProceedToNextState() {
                return false;
            }
        });
        states.put(STAGEOUT, new State(){

            @Override
            public State process(Runner r) throws Exception {
                r.initJobClient();
                if (!r.noFetchOutcome) {
                    r.doGetStdOut();
                    r.doGetStdErr();
                }
                r.doExport();
                r.mustSave = true;
                return Runner.getState(Runner.DONE);
            }

            @Override
            public String getName() {
                return Runner.STAGEOUT;
            }

            @Override
            public boolean autoProceedToNextState() {
                return true;
            }
        });
        states.put(DONE, new State(){

            @Override
            public State process(Runner r) {
                if (!Boolean.parseBoolean(r.builder.getProperty("KeepFinishedJob", "false"))) {
                    try {
                        r.initJobClient();
                        r.mustSave = true;
                        r.jobClient.destroy();
                        r.msg.verbose("Deleted done job " + r.jobClient.getEPR().getAddress().getStringValue());
                    }
                    catch (Exception e) {
                        r.msg.error("Could not delete job", e);
                    }
                }
                return Runner.getState(Runner.FINISHED);
            }

            @Override
            public String getName() {
                return Runner.DONE;
            }

            @Override
            public boolean autoProceedToNextState() {
                return true;
            }
        });
        states.put(FINISHED, new State(){

            @Override
            public State process(Runner r) {
                r.msg.message("Job already finished.");
                return Runner.getState(Runner.FINISHED);
            }

            @Override
            public String getName() {
                return Runner.FINISHED;
            }

            @Override
            public boolean autoProceedToNextState() {
                return false;
            }
        });
    }

    public static interface State {
        public State process(Runner var1) throws Exception;

        public String getName();

        public boolean autoProceedToNextState();
    }
}

