/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.ucc.runner.Queue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class RequestQueue
extends Queue {
    protected File requestDir;

    public RequestQueue(String requestDirname, boolean follow) throws IOException {
        this.requestDir = new File(requestDirname);
        if (!this.requestDir.exists()) {
            this.requestDir.mkdir();
        }
        if (!this.requestDir.isDirectory() || !this.requestDir.canRead()) {
            throw new IOException("Cannot read " + requestDirname);
        }
    }

    public File getRequestDir() {
        return this.requestDir;
    }

    protected synchronized void populate() {
        if (this.getSize() > 0) {
            return;
        }
        String curr = "";
        File[] files = this.sort(this.requestDir.listFiles(this.getFilter()));
        for (int i = 0; i < files.length; ++i) {
            curr = files[i].getAbsolutePath();
            try {
                this.add(curr);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @Override
    protected void update() {
        if (this.getSize() == 0) {
            this.populate();
        }
    }

    protected File[] sort(File[] in) {
        File[] out = in;
        Comparator<File> c = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return (int)(f1.lastModified() - f2.lastModified());
            }
        };
        Arrays.sort(out, c);
        return out;
    }

    protected FileFilter getFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".u") || file.getName().endsWith(".jsdl") || file.getName().endsWith(".xml");
            }
        };
    }
}

