/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public abstract class Queue {
    protected final DelayQueue<QueueEntry<String>> elements = new DelayQueue();
    protected int limit = -1;
    protected int queued = 0;
    protected long delay;

    public Queue() {
        this(0L);
    }

    public Queue(long delay) {
        this.delay = delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    protected boolean canAdd() {
        return this.limit == -1 || this.getSize() < this.limit;
    }

    protected int getSize() {
        return this.elements.size();
    }

    protected abstract void update();

    public void add(String o) throws Exception {
        if (this.limit != -1 && this.getSize() >= this.limit) {
            throw new Exception("Queue limit reached!");
        }
        this.elements.add(new QueueEntry<String>(o, System.currentTimeMillis(), this.delay));
    }

    public void add(String o, long lastAccessed) throws Exception {
        if (this.limit != -1 && this.getSize() >= this.limit) {
            throw new Exception("Queue limit reached!");
        }
        this.elements.add(new QueueEntry<String>(o, lastAccessed, this.delay));
    }

    public String next() {
        this.update();
        QueueEntry e = (QueueEntry)this.elements.poll();
        return e != null ? (String)e.entry : null;
    }

    public String next(long timeout, TimeUnit unit) throws InterruptedException {
        this.update();
        QueueEntry e = (QueueEntry)this.elements.poll(timeout, unit);
        return e != null ? (String)e.entry : null;
    }

    public int length() {
        return this.elements.size();
    }

    public static class QueueEntry<T>
    implements Delayed {
        final long lastAccessed;
        final long queueDelay;
        final T entry;

        public QueueEntry(T entry, long lastAccessed, long queueDelay) {
            this.entry = entry;
            this.lastAccessed = lastAccessed;
            this.queueDelay = queueDelay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.queueDelay - System.currentTimeMillis() + this.lastAccessed, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.lastAccessed - ((QueueEntry)o).lastAccessed);
        }
    }
}

