/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.ucc.runner.Requirement;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemTypeEnumeration;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;

public class OSRequirement
implements Requirement {
    private final OperatingSystemTypeEnumeration.Enum os;

    public OSRequirement(OperatingSystemTypeEnumeration.Enum os) {
        this.os = os;
    }

    @Override
    public String getDescription() {
        return "Operating system: " + this.os;
    }

    @Override
    public boolean isFulfilled(TargetSystemPropertiesDocument.TargetSystemProperties properties) {
        try {
            OperatingSystemType ost = properties.getOperatingSystem();
            if (ost == null) {
                return true;
            }
            return this.os.equals(ost.getOperatingSystemType().getOperatingSystemName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.os == null ? 0 : this.os.toString().hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OSRequirement)) {
            return false;
        }
        return this.os.equals(((OSRequirement)o).os);
    }
}

