/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.ucc.runner.Requirement;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDescriptionDocument;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;

public class ExecutionEnvironmentRequirement
implements Requirement {
    private final String name;
    private final String version;

    public ExecutionEnvironmentRequirement(String name, String version) {
        this.name = name;
        this.version = version;
    }

    @Override
    public String getDescription() {
        return "Execution environment: " + this.name + (this.version != null ? " v" + this.version : "");
    }

    @Override
    public boolean isFulfilled(TargetSystemPropertiesDocument.TargetSystemProperties tss) {
        ExecutionEnvironmentDescriptionDocument.ExecutionEnvironmentDescription[] ee;
        for (ExecutionEnvironmentDescriptionDocument.ExecutionEnvironmentDescription execEnv : ee = tss.getExecutionEnvironmentDescriptionArray()) {
            if (!this.name.equalsIgnoreCase(execEnv.getName())) continue;
            if (this.version == null) {
                return true;
            }
            if (!this.version.equalsIgnoreCase(execEnv.getVersion())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionEnvironmentRequirement other = (ExecutionEnvironmentRequirement)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

