/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.runner;

import de.fzj.unicore.ucc.runner.Requirement;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;

public class ApplicationRequirement
implements Requirement {
    private final String appName;
    private final String appVersion;

    public ApplicationRequirement(String appName, String appVersion) {
        this.appName = appName;
        this.appVersion = appVersion;
    }

    @Override
    public String getDescription() {
        return "Application: " + this.appName + (this.appVersion != null ? " v" + this.appVersion : "");
    }

    @Override
    public boolean isFulfilled(TargetSystemPropertiesDocument.TargetSystemProperties tss) {
        ApplicationResourceType[] apps;
        for (ApplicationResourceType app : apps = tss.getApplicationResourceArray()) {
            if (!this.appName.equalsIgnoreCase(app.getApplicationName())) continue;
            if (this.appVersion == null) {
                return true;
            }
            if (!this.appVersion.equalsIgnoreCase(app.getApplicationVersion())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.appName == null ? 0 : this.appName.hashCode());
        result = 31 * result + (this.appVersion == null ? 0 : this.appVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationRequirement other = (ApplicationRequirement)obj;
        if (this.appName == null ? other.appName != null : !this.appName.equals(other.appName)) {
            return false;
        }
        return !(this.appVersion == null ? other.appVersion != null : !this.appVersion.equals(other.appVersion));
    }
}

