/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.TargetSystemFactoryLister;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TargetSystemLister
implements Iterable<TSSClient> {
    private final IRegistryQuery registry;
    private final IClientConfiguration sec;
    private final MessageWriter msg;

    public TargetSystemLister(IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        this.registry = registry;
        this.sec = sec;
        this.msg = msg;
    }

    public List<TSSClient> list() {
        TargetSystemFactoryLister tsfLister = new TargetSystemFactoryLister(this.registry, this.sec, this.msg);
        ArrayList<TSSClient> tssList = new ArrayList<TSSClient>();
        for (TSFClient tsf : tsfLister) {
            try {
                List eprs = tsf.getAccessibleTargetSystems();
                if (eprs == null) continue;
                for (EndpointReferenceType epr : eprs) {
                    try {
                        TSSClient tss = new TSSClient(epr.getAddress().getStringValue(), epr, this.sec);
                        tssList.add(tss);
                    }
                    catch (Exception ex) {
                        this.msg.verbose("Can't access target system at " + epr.getAddress().getStringValue());
                    }
                }
                if (eprs.size() != 0) continue;
                this.msg.verbose("No accessible target systems at " + tsf.getEPR().getAddress().getStringValue());
            }
            catch (Exception ex) {
                String message = "Can't access target systems at " + tsf.getEPR().getAddress().getStringValue();
                this.msg.error(message, ex);
            }
        }
        return tssList;
    }

    @Override
    public Iterator<TSSClient> iterator() {
        return this.list().iterator();
    }

    public TSSClient getTSS(String sitename) {
        for (TSSClient c : this) {
            if (!sitename.equalsIgnoreCase(c.getTargetSystemName())) continue;
            return c;
        }
        return null;
    }
}

