/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.GridTask;
import de.fzj.unicore.ucc.helpers.GridTaskResult;
import de.fzj.unicore.ucc.helpers.GridTaskTarget;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xmlbeans.client.Resources;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TargetSystemFactoryLister
implements Iterable<TSFClient> {
    private final IRegistryQuery registry;
    private final IClientConfiguration sec;
    private String[] blacklistPatterns = new String[0];
    private int runningLimit = 10;
    private int timeout = 10;
    private final TSFFilter filter;
    private final MessageWriter msg;

    public TargetSystemFactoryLister(IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        this(registry, sec, null, msg);
    }

    public TargetSystemFactoryLister(IRegistryQuery registry, IClientConfiguration sec, TSFFilter filter, MessageWriter msg) {
        this.registry = registry;
        this.sec = sec;
        this.msg = msg;
        this.filter = filter;
    }

    public void setBlacklist(String[] blacklist) {
        this.blacklistPatterns = blacklist;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public List<TSFClient> list() {
        List tss = null;
        try {
            List tasks = this.runOnEachTSF(new GetTSFClientTask());
            tss = GridTaskResult.completeAsyncTasks(tasks, this.timeout, this.msg);
        }
        catch (Exception e) {
            String message = "Can't create list of target systems.";
            this.msg.error(message, e);
        }
        return tss;
    }

    @Override
    public Iterator<TSFClient> iterator() {
        return this.list().iterator();
    }

    public <T> List<GridTaskResult<T>> runOnEachTSF(GridTask<T> task) throws Exception {
        ArrayList<GridTaskResult<T>> result = new ArrayList<GridTaskResult<T>>();
        List tsfs = this.registry.listServices(TargetSystemFactory.TSF_PORT);
        for (EndpointReferenceType epr : tsfs) {
            boolean submittedTask;
            if (this.filter != null && !this.filter.accept(epr)) continue;
            if (this.isBlacklisted(epr)) {
                this.msg.verbose("Ignoring blacklisted site " + epr.getAddress().getStringValue());
                continue;
            }
            GridTaskTarget<T> worker = new GridTaskTarget<T>(this.sec, this.registry, this.msg);
            worker.setEpr(epr);
            worker.setTask(task);
            do {
                submittedTask = false;
                int running = GridTaskTarget.getRunningTasks();
                if (running < this.runningLimit) {
                    Future future = Resources.getExecutorService().submit(worker);
                    GridTaskResult gtr = new GridTaskResult(future, worker);
                    result.add(gtr);
                    submittedTask = true;
                    continue;
                }
                Thread.sleep(500L);
            } while (!submittedTask);
        }
        return result;
    }

    protected boolean isBlacklisted(EndpointReferenceType epr) {
        boolean result = false;
        String url = epr.getAddress().getStringValue();
        for (String pattern : this.blacklistPatterns) {
            if (!url.contains(pattern)) continue;
            return true;
        }
        return result;
    }

    public static interface TSFFilter {
        public boolean accept(EndpointReferenceType var1);

        public boolean accept(TSFClient var1);
    }

    public static class GetTSFClientTask
    implements GridTask<TSFClient> {
        private final TSFFilter filter;

        public GetTSFClientTask() {
            this(null);
        }

        public GetTSFClientTask(TSFFilter filter) {
            this.filter = filter;
        }

        private TSFClient createClient(GridTaskTarget<TSFClient> worker) throws Exception {
            EndpointReferenceType epr = worker.getEpr();
            return new TSFClient(epr.getAddress().getStringValue(), epr, worker.getSecurity());
        }

        @Override
        public TSFClient run(GridTaskTarget<TSFClient> target) throws Exception {
            TSFClient client = this.createClient(target);
            client.getCurrentTime();
            return this.filter != null ? (this.filter.accept(client) ? client : null) : client;
        }
    }
}

