/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.StorageFactoryLister;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageLister
implements Iterable<StorageClient> {
    private static final Logger logger = Logger.getLogger((String)StorageLister.class.getName());
    final TSSClient tss;
    final IRegistryQuery registry;
    final IClientConfiguration securityProperties;
    final MessageWriter msg;

    public StorageLister(TSSClient tss, IClientConfiguration securityProperties, MessageWriter msg) {
        this.tss = tss;
        this.registry = null;
        this.securityProperties = securityProperties;
        this.msg = msg;
    }

    public StorageLister(IRegistryQuery registry, IClientConfiguration securityProperties, MessageWriter msg) {
        this.tss = null;
        this.registry = registry;
        this.securityProperties = securityProperties;
        this.msg = msg;
    }

    public List<StorageClient> list() {
        try {
            List<EndpointReferenceType> eprs = this.getStorageEPRs();
            ArrayList<StorageClient> sms = new ArrayList<StorageClient>();
            for (EndpointReferenceType epr : eprs) {
                sms.add(new StorageClient(epr.getAddress().getStringValue(), epr, this.getSecurityProperties()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't create Storage Client list.", (Throwable)e);
        }
        return null;
    }

    @Override
    public Iterator<StorageClient> iterator() {
        try {
            final List<EndpointReferenceType> sms = this.getStorageEPRs();
            return new Iterator<StorageClient>(){
                Iterator<EndpointReferenceType> eprs;
                {
                    this.eprs = sms.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.eprs.hasNext();
                }

                @Override
                public StorageClient next() {
                    EndpointReferenceType epr = this.eprs.next();
                    try {
                        return new StorageClient(epr.getAddress().getStringValue(), epr, StorageLister.this.getSecurityProperties());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Can't create Storage Client.", (Throwable)e);
                        return null;
                    }
                }

                @Override
                public void remove() {
                    this.eprs.remove();
                }
            };
        }
        catch (Exception e) {
            this.msg.error("Error listing storages", e);
            List x = Collections.emptyList();
            return x.iterator();
        }
    }

    protected List<EndpointReferenceType> getStorageEPRs() throws Exception {
        if (this.tss != null) {
            return this.tss.getStorages();
        }
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        result.addAll(this.registry.listAccessibleServices(StorageManagement.SMS_PORT));
        for (StorageFactoryClient sfc : new StorageFactoryLister(this.registry, this.securityProperties, this.msg)) {
            this.msg.verbose("Storage factory at " + sfc.getEPR().getAddress().getStringValue());
            List storages = sfc.getAccessibleStorages();
            if (storages == null) continue;
            result.addAll(storages);
        }
        return result;
    }

    protected IClientConfiguration getSecurityProperties() {
        return this.securityProperties;
    }

    public StorageClient getStorage(String storageName) {
        for (StorageClient c : this) {
            try {
                String name = FileSystemDocument.Factory.parse((String)c.getResourceProperty(StorageManagement.RPFileSystem)).getFileSystem().getName();
                if (!name.equalsIgnoreCase(storageName)) continue;
                return c;
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

