/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.ucc.InaccessibleServiceException;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.GridTask;
import de.fzj.unicore.ucc.helpers.GridTaskTarget;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xmlbeans.client.Resources;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageFactoryLister
implements Iterable<StorageFactoryClient> {
    private final IRegistryQuery registry;
    private final IClientConfiguration sec;
    private String[] blacklistPatterns = new String[0];
    private int runningLimit = 10;
    private final MessageWriter msg;
    private final StorageFactoryFilter filter;

    public StorageFactoryLister(IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg, StorageFactoryFilter filter) {
        this.registry = registry;
        this.sec = sec;
        this.msg = msg;
        this.filter = filter;
    }

    public StorageFactoryLister(IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        this(registry, sec, msg, null);
    }

    public void setBlacklist(String[] blacklist) {
        this.blacklistPatterns = blacklist;
    }

    public List<StorageFactoryClient> list() {
        ArrayList<StorageFactoryClient> sfs = new ArrayList<StorageFactoryClient>();
        try {
            List<Future<StorageFactoryClient>> tasks = this.runOnEachSMF(new GetStorageFactoryClientTask(this.filter));
            while (tasks.size() > 0) {
                Future<StorageFactoryClient> task = tasks.get(0);
                try {
                    StorageFactoryClient res = task.get(500L, TimeUnit.MILLISECONDS);
                    if (res != null) {
                        sfs.add(res);
                        tasks.remove(0);
                        continue;
                    }
                    tasks.remove(0);
                }
                catch (TimeoutException te) {
                }
                catch (ExecutionException ee) {
                    if (!(ee.getCause() instanceof InaccessibleServiceException)) {
                        String message = "Error accessing target system factory.";
                        this.msg.error(message, ee.getCause());
                    }
                    tasks.remove(0);
                }
            }
        }
        catch (Exception e) {
            String message = "Can't create list of target systems.";
            this.msg.error(message, e);
        }
        return sfs;
    }

    @Override
    public Iterator<StorageFactoryClient> iterator() {
        return this.list().iterator();
    }

    public <T> List<Future<T>> runOnEachSMF(GridTask<T> task) throws Exception {
        ArrayList<Future<T>> result = new ArrayList<Future<T>>();
        List smfs = this.registry.listServices(StorageFactory.SMF_PORT);
        for (EndpointReferenceType epr : smfs) {
            boolean submittedTask;
            if (this.filter != null && !this.filter.accept(epr)) continue;
            if (this.isBlacklisted(epr)) {
                this.msg.verbose("Ignoring blacklisted site " + epr.getAddress().getStringValue());
                continue;
            }
            GridTaskTarget<T> worker = new GridTaskTarget<T>(this.sec, this.registry, this.msg);
            worker.setEpr(epr);
            worker.setTask(task);
            do {
                submittedTask = false;
                int running = GridTaskTarget.getRunningTasks();
                if (running < this.runningLimit) {
                    result.add(Resources.getExecutorService().submit(worker));
                    submittedTask = true;
                    continue;
                }
                Thread.sleep(500L);
            } while (!submittedTask);
        }
        return result;
    }

    protected boolean isBlacklisted(EndpointReferenceType epr) {
        boolean result = false;
        String url = epr.getAddress().getStringValue();
        for (String pattern : this.blacklistPatterns) {
            if (!url.contains(pattern)) continue;
            return true;
        }
        return result;
    }

    public static interface StorageFactoryFilter {
        public boolean accept(EndpointReferenceType var1);

        public boolean accept(StorageFactoryClient var1);
    }

    public static class GetStorageFactoryClientTask
    implements GridTask<StorageFactoryClient> {
        private final StorageFactoryFilter filter;

        public GetStorageFactoryClientTask() {
            this(null);
        }

        public GetStorageFactoryClientTask(StorageFactoryFilter filter) {
            this.filter = filter;
        }

        private StorageFactoryClient createClient(GridTaskTarget<StorageFactoryClient> worker) throws Exception {
            EndpointReferenceType epr = worker.getEpr();
            return new StorageFactoryClient(epr.getAddress().getStringValue(), epr, worker.getSecurity());
        }

        @Override
        public StorageFactoryClient run(GridTaskTarget<StorageFactoryClient> target) throws Exception {
            StorageFactoryClient client = this.createClient(target);
            client.getCurrentTime();
            return this.filter != null ? (this.filter.accept(client) ? client : null) : client;
        }
    }
}

