/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;

public class ResourceCache {
    private static final ResourceCache cache = new ResourceCache();
    private final Map<String, Cache> caches;
    private final CacheManager cacheManager;
    private final AtomicInteger cacheHits = new AtomicInteger(0);
    private String ehCacheConfig = "<ehcache>\n<defaultCache maxElementsInMemory=\"500\"\neternal=\"false\"\ntimeToIdleSeconds=\"300\"\ntimeToLiveSeconds=\"300\"\noverflowToDisk=\"false\"\ndiskPersistent=\"false\"\ndiskExpiryThreadIntervalSeconds=\"120\"/>\n</ehcache>";

    private ResourceCache() {
        this.caches = new ConcurrentHashMap<String, Cache>();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.ehCacheConfig.getBytes());
        this.cacheManager = CacheManager.create((InputStream)bis);
    }

    public static ResourceCache getInstance() {
        return cache;
    }

    public void put(String cacheID, Object key, Object value) {
        Cache c = this.doGetCache(cacheID);
        Element el = new Element(key, value);
        c.put(el);
    }

    public Object get(String cacheID, Object key) {
        Cache c = this.doGetCache(cacheID);
        Element el = c.get(key);
        if (el == null) {
            return null;
        }
        this.cacheHits.incrementAndGet();
        return el.getObjectValue();
    }

    public <T> T getAs(String cacheID, Object key, Class<T> target) {
        Object o = this.get(cacheID, key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public Statistics getStatistics(String cacheID) {
        Cache c = this.doGetCache(cacheID);
        return c.getStatistics();
    }

    public int getCacheHits() {
        return this.cacheHits.intValue();
    }

    private synchronized Cache doGetCache(String id) {
        if (id == null) {
            throw new NullPointerException("cache id can't be null");
        }
        Cache c = this.caches.get(id);
        if (c == null) {
            this.cacheManager.addCache(id);
            c = this.cacheManager.getCache(id);
            this.caches.put(id, c);
        }
        return c;
    }
}

