/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.DefaultMessageWriter;
import de.fzj.unicore.ucc.helpers.ResourceCache;
import de.fzj.unicore.ucc.helpers.StorageLister;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Location {
    protected boolean isLocal = false;
    protected boolean isRaw = false;
    protected String smsEpr;
    protected String protocol;
    protected String name;
    protected final MessageWriter msg;
    protected final IRegistryQuery registry;
    protected final IClientConfiguration sec;
    protected final boolean doResolve;
    protected static final String u6URLRE = "(([[\\w-]]+):)?([\\w-])+://(.)*#(.)*";
    public static final Pattern pattern = Pattern.compile("(([[\\w-]]+):)?([\\w-])+://(.)*#(.)*");
    protected static final String rawURLRE = "([\\w-])+:(.)*";
    public static final Pattern rawPattern = Pattern.compile("([\\w-])+:(.)*");

    public Location(String desc, IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg, boolean doResolve) {
        this.msg = msg != null ? msg : new DefaultMessageWriter();
        this.doResolve = doResolve;
        this.registry = registry;
        this.sec = sec;
        if (!this.parseDesc(desc)) {
            throw new IllegalArgumentException("<" + desc + "> is not a valid location.");
        }
    }

    public Location(String desc, IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        this(desc, registry, sec, msg, true);
    }

    public static boolean isU6URL(String url) {
        Matcher m = pattern.matcher(url);
        return m.find();
    }

    public static boolean isRawURL(String url) {
        boolean isU6 = Location.isU6URL(url);
        Matcher m = rawPattern.matcher(url);
        return !isU6 && m.find();
    }

    protected boolean parseDesc(String desc) {
        if ((desc.startsWith("u6://") || desc.startsWith("unicore6://")) && this.doResolve) {
            boolean found = this.resolveLocation(desc);
            if (found) {
                this.isLocal = false;
                this.isRaw = false;
            }
            return found;
        }
        if (Location.isU6URL(desc)) {
            String[] s1 = desc.split("#");
            try {
                this.name = s1[s1.length - 1];
                String[] s2 = s1[0].split(":", 2);
                if (s2[1].toLowerCase().startsWith("http")) {
                    this.protocol = s2[0];
                    this.smsEpr = s2[1];
                } else {
                    this.protocol = "BFT";
                    this.smsEpr = s1[0];
                }
                return true;
            }
            catch (Exception e) {
                this.msg.error("Error: <" + desc + "> does not denote a valid UNICORE 6 URI", e);
                return false;
            }
        }
        if (Location.isRawURL(desc)) {
            this.smsEpr = desc;
            this.name = null;
            this.isRaw = true;
            return true;
        }
        this.name = desc;
        this.isLocal = true;
        return true;
    }

    private boolean resolveLocation(String desc) {
        if (this.sec == null) {
            throw new IllegalArgumentException("Security properties may not be null.");
        }
        if (this.registry == null) {
            throw new IllegalArgumentException("Registry may not be null.");
        }
        try {
            desc = this.resolveProtocol(desc);
            String l = desc.split("://")[1];
            String[] pathSpec = l.split("/", 3);
            String tssName = pathSpec[0];
            String location = null;
            if (pathSpec.length > 1) {
                location = pathSpec[1];
            }
            if (pathSpec.length > 2) {
                this.name = pathSpec[2];
                if (this.name == null || this.name.length() == 0) {
                    this.name = "/";
                }
            }
            boolean foundLocation = false;
            boolean fromCache = false;
            StorageClient sms = null;
            ResourceCache cache = ResourceCache.getInstance();
            String cacheKey = tssName;
            this.smsEpr = cache.getAs("locations", cacheKey, String.class);
            if (this.smsEpr == null && location != null) {
                cacheKey = cacheKey + "/" + location;
                this.smsEpr = cache.getAs("locations", cacheKey, String.class);
            } else {
                this.getNameForStorage(l);
            }
            if (this.smsEpr != null) {
                foundLocation = true;
                fromCache = true;
            }
            if (this.smsEpr == null) {
                TSSClient tss = new TargetSystemLister(this.registry, this.sec, this.msg).getTSS(tssName);
                if (tss == null) {
                    foundLocation = this.checkStorage(tssName, l);
                    if (foundLocation) {
                        cacheKey = tssName;
                    }
                } else {
                    sms = new StorageLister(tss, this.sec, this.msg).getStorage(location);
                    if (sms != null) {
                        this.smsEpr = sms.getEPR().getAddress().getStringValue();
                        foundLocation = true;
                        cacheKey = tssName + "/" + location;
                    } else {
                        this.msg.verbose("Checking jobs on TSS <" + tssName + ">.");
                        for (EndpointReferenceType e : tss.getJobs()) {
                            try {
                                this.msg.verbose("Check " + e.getAddress().getStringValue());
                                if (!e.getAddress().getStringValue().endsWith(location)) continue;
                                this.smsEpr = new JobClient(e.getAddress().getStringValue(), e, this.sec).getResourcePropertiesDocument().getJobProperties().getWorkingDirectoryReference().getAddress().getStringValue();
                                foundLocation = true;
                                cacheKey = tssName + "/" + location;
                            }
                            catch (Throwable ex) {
                                this.msg.verbose("Error on access: " + ex.getMessage());
                            }
                        }
                    }
                }
            }
            if (foundLocation) {
                if (this.msg.isVerbose()) {
                    this.msg.verbose("Resolved " + (fromCache ? "cached" : "") + " location " + desc + " as <" + this.smsEpr + ">, file name <" + this.name + ">");
                }
                if (!fromCache) {
                    cache.put("locations", cacheKey, this.smsEpr);
                }
            } else {
                this.msg.verbose("No matching location found!");
            }
            return foundLocation;
        }
        catch (Exception e) {
            this.msg.error("Error resolving location.", e);
            return false;
        }
    }

    private String resolveProtocol(String desc) {
        String[] protospec = desc.split("\\?");
        if (protospec.length == 2) {
            String p = protospec[1];
            desc = protospec[0];
            this.protocol = p.contains("protocol=") ? p.split("protocol=")[1] : "BFT";
        } else {
            this.protocol = "BFT";
        }
        return desc;
    }

    private boolean checkStorage(String storageName, String location) {
        StorageClient sms = new StorageLister(this.registry, this.sec, this.msg).getStorage(storageName);
        if (sms != null) {
            this.smsEpr = sms.getEPR().getAddress().getStringValue();
            this.getNameForStorage(location);
            return true;
        }
        this.msg.verbose("No Target system or Storage named <" + storageName + "> found.");
        return false;
    }

    private void getNameForStorage(String location) {
        String[] pathSpec = location.split("/", 2);
        if (pathSpec.length > 1) {
            this.name = pathSpec[1];
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = "/";
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isUnicoreURL() {
        return !this.isRaw && !this.isLocal;
    }

    public boolean isRaw() {
        return this.isRaw;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSmsEpr() {
        return this.smsEpr;
    }

    public String getUnicore6URI() {
        if (this.isLocal() || this.smsEpr == null) {
            return null;
        }
        return this.protocol + ":" + this.smsEpr + "#/" + this.name;
    }

    public String resolve() {
        if (this.isRaw) {
            return this.smsEpr;
        }
        return this.getUnicore6URI();
    }
}

