/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.ucc.InaccessibleServiceException;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.GridTask;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class GridTaskTarget<V>
implements Callable<V> {
    private static final Logger logger = Log.getLogger((String)"UCC", GridTaskTarget.class);
    protected EndpointReferenceType epr;
    protected final IClientConfiguration security;
    protected final IRegistryQuery registry;
    protected final MessageWriter msg;
    protected int connectionTimeout = 10000;
    protected GridTask<V> task;
    protected BaseUASClient client;
    protected static AtomicInteger runningTasks = new AtomicInteger(0);

    public GridTaskTarget(IClientConfiguration securityProperties, IRegistryQuery registry, MessageWriter msg) {
        this.security = securityProperties;
        this.registry = registry;
        this.msg = msg;
    }

    public IClientConfiguration getSecurity() {
        return this.security;
    }

    public IRegistryQuery getRegistry() {
        return this.registry;
    }

    public MessageWriter getMessageWriter() {
        return this.msg;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start task at " + this.epr.getAddress().getStringValue()));
            }
            runningTasks.incrementAndGet();
            if (!this.isAccessible()) {
                String msg = "Service " + this.epr.getAddress().getStringValue() + " is not accessible.";
                logger.debug((Object)msg);
                throw new InaccessibleServiceException(msg);
            }
            V v = this.task.run(this);
            return v;
        }
        finally {
            runningTasks.decrementAndGet();
        }
    }

    public EndpointReferenceType getEpr() {
        return this.epr;
    }

    public void setEpr(EndpointReferenceType epr) {
        this.epr = epr;
    }

    public void setTask(GridTask<V> task) {
        this.task = task;
    }

    public void setConnectionTimeOut(int timeout) {
        this.connectionTimeout = timeout;
    }

    public synchronized BaseUASClient getClient() throws Exception {
        if (this.client == null) {
            this.security.getExtraSettings().setProperty("http.connection.timeout", String.valueOf(this.connectionTimeout));
            this.client = new BaseUASClient(this.epr.getAddress().getStringValue(), this.epr, this.security);
        }
        return this.client;
    }

    protected boolean isAccessible() {
        try {
            this.getClient().getCurrentTime();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Service at " + this.epr.getAddress().getStringValue()));
            }
            return true;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No access at " + this.epr.getAddress().getStringValue()));
            }
            return false;
        }
    }

    public static int getRunningTasks() {
        return runningTasks.intValue();
    }
}

