/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.ucc.InaccessibleServiceException;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.GridTaskTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GridTaskResult<T>
implements Future<T> {
    private final Future<T> future;
    private final GridTaskTarget<T> target;

    public GridTaskResult(Future<T> future, GridTaskTarget<T> target) {
        this.future = future;
        this.target = target;
    }

    public GridTaskTarget<T> getTarget() {
        return this.target;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public static <T> List<T> completeAsyncTasks(List<GridTaskResult<T>> results, int timeout, MessageWriter msg) throws InterruptedException {
        ArrayList<T> finalResults = new ArrayList<T>();
        for (GridTaskResult<T> f : results) {
            String address;
            try {
                T result = f.get(timeout, TimeUnit.SECONDS);
                if (result == null) continue;
                finalResults.add(result);
            }
            catch (ExecutionException ee) {
                if (ee.getCause() instanceof InaccessibleServiceException) continue;
                address = f.getTarget().getEpr().getAddress().getStringValue();
                String message = "Error accessing " + address;
                msg.error(message, ee.getCause());
            }
            catch (TimeoutException ex) {
                address = f.getTarget().getEpr().getAddress().getStringValue();
                msg.error("Timeout exceeded waiting for " + address, null);
            }
        }
        return finalResults;
    }
}

