/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.ucc.MessageWriter;
import org.apache.log4j.Logger;

public class DefaultMessageWriter
implements MessageWriter {
    private static final Logger logger = Logger.getLogger((String)"UCC");
    private final boolean verbose;

    public DefaultMessageWriter() {
        this.verbose = false;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void error(String message, Throwable cause) {
        System.err.println(message);
        if (cause != null) {
            System.err.println("The root error was: " + this.getDetailMessage(cause));
            if (this.verbose) {
                cause.printStackTrace();
            } else {
                System.err.println("Re-run in verbose mode (-v) to see the full error stack trace.");
            }
        }
        logger.error((Object)message, cause);
    }

    @Override
    public void message(String message) {
        System.out.println(message);
        logger.info((Object)message);
    }

    @Override
    public void verbose(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
        logger.debug((Object)message);
    }

    private String getDetailMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = throwable;
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        if (message != null) {
            sb.append(type).append(": ").append(message);
        } else {
            sb.append(type).append(" (no further message available)");
        }
        return sb.toString();
    }
}

